/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.smithy.diff.ChangedShape;
import software.amazon.smithy.diff.DiffEvaluator;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;

public class AddedOperationInputOutput
implements DiffEvaluator {
    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        return differences.changedShapes(OperationShape.class).flatMap(change -> this.checkOperation(differences.getNewModel(), (ChangedShape<OperationShape>)change).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> checkOperation(Model newModel, ChangedShape<OperationShape> change) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>(2);
        if (!change.getOldShape().getInput().isPresent() && change.getNewShape().getInput().isPresent()) {
            this.validateChange("Input", newModel, (Shape)change.getNewShape(), (ShapeId)change.getNewShape().getInput().get()).ifPresent(events::add);
        }
        if (!change.getOldShape().getOutput().isPresent() && change.getNewShape().getOutput().isPresent()) {
            this.validateChange("Output", newModel, (Shape)change.getNewShape(), (ShapeId)change.getNewShape().getOutput().get()).ifPresent(events::add);
        }
        return events;
    }

    private Optional<ValidationEvent> validateChange(String rel, Model model, Shape operation, ShapeId target) {
        String eventId = "AddedOperation" + rel;
        return model.getShape(target).flatMap(Shape::asStructureShape).map(struct -> {
            if (struct.getAllMembers().values().stream().noneMatch(MemberShape::isRequired)) {
                return ValidationEvent.builder().eventId(eventId).severity(Severity.NOTE).shape(operation).message(String.format("%s shape `%s` was added to the `%s` operation", rel, target, operation.getId())).build();
            }
            return ValidationEvent.builder().eventId(eventId).severity(Severity.ERROR).shape(operation).message(String.format("%s shape `%s` was added to the `%s` operation, and this structure contains one or more required members. %s can only be added to an operation if the targeted structure contains no required members.", rel, target, operation.getId(), rel)).build();
        });
    }
}

