/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.ValidationEvent;

public class ModifiedTrait
extends AbstractDiffEvaluator {
    public static final String DIFF_ERROR_ADD = "diff.error.add";
    public static final String DIFF_ERROR_REMOVE = "diff.error.remove";
    public static final String DIFF_ERROR_UPDATE = "diff.error.update";
    public static final String DIFF_ERROR_CONST = "diff.error.const";

    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        Model newModel = differences.getNewModel();
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        Set<ShapeId> errorOnAdd = ModifiedTrait.findMatchingTraitDefNamesWithTag(newModel, DIFF_ERROR_ADD);
        Set<ShapeId> errorOnRemove = ModifiedTrait.findMatchingTraitDefNamesWithTag(newModel, DIFF_ERROR_REMOVE);
        Set<ShapeId> errorOnReplace = ModifiedTrait.findMatchingTraitDefNamesWithTag(newModel, DIFF_ERROR_UPDATE);
        Set<ShapeId> errorOnAddOrRemove = ModifiedTrait.findMatchingTraitDefNamesWithTag(newModel, DIFF_ERROR_CONST);
        errorOnAdd.addAll(errorOnAddOrRemove);
        errorOnRemove.addAll(errorOnAddOrRemove);
        errorOnReplace.addAll(errorOnAddOrRemove);
        differences.changedShapes().forEach(changedShape -> changedShape.getTraitDifferences().forEach((traitName, pair) -> {
            Trait oldTrait = (Trait)pair.getLeft();
            Trait newTrait = (Trait)pair.getRight();
            if (errorOnAdd.contains(traitName) && oldTrait == null) {
                events.add(this.error((Shape)changedShape.getNewShape(), (FromSourceLocation)newTrait, String.format("It is a breaking change to add the `%s` trait to the existing `%s` %s shape. The added trait value is: %s", traitName, changedShape.getNewShape().getId(), changedShape.getNewShape().getType(), Node.prettyPrintJson((Node)newTrait.toNode()))));
            } else if (errorOnRemove.contains(traitName) && newTrait == null) {
                events.add(this.error((Shape)changedShape.getNewShape(), String.format("It is a breaking change to remove the `%s` trait from the `%s` %s shape. The removed trait value was: %s", traitName, changedShape.getNewShape().getId(), changedShape.getNewShape().getType(), Node.prettyPrintJson((Node)oldTrait.toNode()))));
            } else if (errorOnReplace.contains(traitName)) {
                events.add(this.error((Shape)changedShape.getNewShape(), (FromSourceLocation)newTrait, String.format("It is a breaking change to change the value of the `%s` trait on the `%s` %s shape. The old trait value was: %s. The new trait value is: %s", traitName, changedShape.getNewShape().getId(), changedShape.getNewShape().getType(), Node.prettyPrintJson((Node)oldTrait.toNode()), Node.prettyPrintJson((Node)newTrait.toNode()))));
            }
        }));
        return events;
    }

    private static Set<ShapeId> findMatchingTraitDefNamesWithTag(Model model, String tag) {
        return model.getTraitShapes().stream().filter(def -> def.getTags().contains(tag)).map(Shape::getId).collect(Collectors.toSet());
    }
}

