/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import software.amazon.smithy.diff.ChangedMetadata;
import software.amazon.smithy.diff.ChangedShape;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.utils.Pair;

public final class Differences {
    private final Model oldModel;
    private final Model newModel;
    private final List<ChangedShape<Shape>> changedShapes = new ArrayList<ChangedShape<Shape>>();
    private final List<ChangedMetadata> changedMetadata = new ArrayList<ChangedMetadata>();

    private Differences(Model oldModel, Model newModel) {
        this.oldModel = oldModel;
        this.newModel = newModel;
        Differences.detectMetadataChanges(oldModel, newModel, this);
        Differences.detectShapeChanges(oldModel, newModel, this);
    }

    static Differences detect(Model oldModel, Model newModel) {
        return new Differences(oldModel, newModel);
    }

    public Model getOldModel() {
        return this.oldModel;
    }

    public Model getNewModel() {
        return this.newModel;
    }

    public Stream<Shape> addedShapes() {
        return this.newModel.getShapeIndex().shapes().filter(shape -> !this.oldModel.getShapeIndex().getShape(shape.getId()).isPresent());
    }

    public <T extends Shape> Stream<T> addedShapes(Class<T> shapeType) {
        return this.addedShapes().filter(shapeType::isInstance).map(shapeType::cast);
    }

    public Stream<Pair<String, Node>> addedMetadata() {
        return this.newModel.getMetadata().entrySet().stream().filter(entry -> !this.oldModel.getMetadata().containsKey(entry.getKey())).map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)((Node)entry.getValue())));
    }

    public Stream<Shape> removedShapes() {
        return this.oldModel.getShapeIndex().shapes().filter(shape -> !this.newModel.getShapeIndex().getShape(shape.getId()).isPresent());
    }

    public <T extends Shape> Stream<T> removedShapes(Class<T> shapeType) {
        return this.removedShapes().filter(shapeType::isInstance).map(shapeType::cast);
    }

    public Stream<Pair<String, Node>> removedMetadata() {
        return this.oldModel.getMetadata().entrySet().stream().filter(entry -> !this.newModel.getMetadata().containsKey(entry.getKey())).map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)((Node)entry.getValue())));
    }

    public Stream<ChangedShape<Shape>> changedShapes() {
        return this.changedShapes.stream();
    }

    public <T extends Shape> Stream<ChangedShape<T>> changedShapes(Class<T> type) {
        return this.changedShapes().filter(change -> type.isInstance(change.getOldShape()) && type.isInstance(change.getNewShape())).map(change -> change);
    }

    public Stream<ChangedMetadata> changedMetadata() {
        return this.changedMetadata.stream();
    }

    private static void detectShapeChanges(Model oldModel, Model newModel, Differences differences) {
        for (Shape oldShape : oldModel.getShapeIndex().toSet()) {
            newModel.getShapeIndex().getShape(oldShape.getId()).ifPresent(newShape -> {
                if (!oldShape.equals(newShape)) {
                    differences.changedShapes.add(new ChangedShape<Shape>(oldShape, (Shape)newShape));
                }
            });
        }
    }

    private static void detectMetadataChanges(Model oldModel, Model newModel, Differences differences) {
        oldModel.getMetadata().forEach((k, v) -> {
            if (newModel.getMetadata().containsKey(k) && !((Node)newModel.getMetadata().get(k)).equals(v)) {
                differences.changedMetadata.add(new ChangedMetadata((String)k, (Node)v, (Node)newModel.getMetadata().get(k)));
            }
        });
    }
}

