/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.diff.ChangedShape;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.ValidationEvent;

public class RemovedOperationError
extends AbstractDiffEvaluator {
    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        return differences.changedShapes(OperationShape.class).flatMap(change -> this.createErrorViolations((ChangedShape<OperationShape>)change).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> createErrorViolations(ChangedShape<OperationShape> change) {
        if (change.getOldShape().getErrors().equals(change.getNewShape().getErrors())) {
            return Collections.emptyList();
        }
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (ShapeId id : change.getOldShape().getErrors()) {
            if (change.getNewShape().getErrors().contains(id)) continue;
            events.add(this.warning((Shape)change.getNewShape(), String.format("The `%s` error was removed from the `%s` operation.", change.getShapeId(), id)));
        }
        return events;
    }
}

