/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.sisu.space;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.DeferredClass;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.ClassSpace;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.FileEntryIterator;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.NamedClass;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.ResourceEnumeration;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.Streams;

public class URLClassSpace
implements ClassSpace {
    private static final String MANIFEST_ENTRY = "META-INF/MANIFEST.MF";
    private static final URL[] NO_URLS;
    private static final Enumeration<URL> NO_ENTRIES;
    private static final String[] EMPTY_CLASSPATH;
    private static final ClassLoader SYSTEM_LOADER;
    private static final String SYSTEM_CLASSPATH;
    private final ClassLoader loader;
    private final String pathDetails;
    private URL[] classPath;

    public URLClassSpace(ClassLoader loader) {
        this.loader = loader;
        this.pathDetails = null;
    }

    public URLClassSpace(ClassLoader loader, URL[] path) {
        this.loader = loader;
        this.pathDetails = Arrays.toString(path);
        this.classPath = null != path && path.length > 0 ? URLClassSpace.expandClassPath(path) : NO_URLS;
    }

    @Override
    public final Class<?> loadClass(String name) {
        try {
            return this.loader.loadClass(name);
        }
        catch (Exception e) {
            throw new TypeNotPresentException(name, e);
        }
        catch (LinkageError e) {
            throw new TypeNotPresentException(name, e);
        }
    }

    @Override
    public final DeferredClass<?> deferLoadClass(String name) {
        return new NamedClass(this, name);
    }

    @Override
    public final URL getResource(String name) {
        return this.loader.getResource(name);
    }

    @Override
    public final Enumeration<URL> getResources(String name) {
        try {
            Enumeration<URL> resources = this.loader.getResources(name);
            return null != resources ? resources : NO_ENTRIES;
        }
        catch (IOException e) {
            return NO_ENTRIES;
        }
    }

    @Override
    public final Enumeration<URL> findEntries(String path, String glob, boolean recurse) {
        if (null != SYSTEM_LOADER && this.loader == SYSTEM_LOADER && null == this.pathDetails && !recurse && null != glob && glob.indexOf(42) < 0) {
            return this.getResources(ResourceEnumeration.normalizeSearchPath(path) + glob);
        }
        return new ResourceEnumeration(path, glob, recurse, this.getClassPath());
    }

    public final URL[] getURLs() {
        return (URL[])this.getClassPath().clone();
    }

    public final int hashCode() {
        return this.loader.hashCode();
    }

    public final boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof URLClassSpace) {
            return this.loader.equals(((URLClassSpace)rhs).loader);
        }
        return false;
    }

    public final String toString() {
        return null == this.pathDetails ? this.loader.toString() : this.loader + "(" + this.pathDetails + ")";
    }

    private synchronized URL[] getClassPath() {
        if (null == this.classPath) {
            for (ClassLoader l = this.loader; l != null; l = l.getParent()) {
                if (l instanceof URLClassLoader) {
                    URL[] path = ((URLClassLoader)l).getURLs();
                    if (null == path || path.length <= 0) continue;
                    this.classPath = URLClassSpace.expandClassPath(path);
                    break;
                }
                if (null == SYSTEM_LOADER || l != SYSTEM_LOADER) continue;
                this.classPath = URLClassSpace.expandClassPath(URLClassSpace.getSystemClassPath());
                break;
            }
            if (null == this.classPath) {
                this.classPath = NO_URLS;
            }
        }
        return this.classPath;
    }

    private static URL[] getSystemClassPath() {
        String[] paths = SYSTEM_CLASSPATH.split(File.pathSeparator);
        URL[] urls = new URL[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            try {
                urls[i] = new File(paths[i]).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                urls[i] = null;
            }
        }
        return urls;
    }

    private static URL[] expandClassPath(URL[] classPath) {
        ArrayList<URL> searchPath = new ArrayList<URL>();
        Collections.addAll(searchPath, classPath);
        ArrayList<URL> expandedPath = new ArrayList<URL>();
        HashSet<String> visited = new HashSet<String>();
        for (int i = 0; i < searchPath.size(); ++i) {
            String[] classPathEntries;
            URL url = URLClassSpace.normalizeEntry((URL)searchPath.get(i));
            if (null == url || !visited.add(url.toString())) continue;
            expandedPath.add(url);
            try {
                classPathEntries = URLClassSpace.getClassPathEntries(url);
            }
            catch (IOException e) {
                continue;
            }
            for (String entry : classPathEntries) {
                try {
                    searchPath.add(new URL(url, entry));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return expandedPath.toArray(new URL[expandedPath.size()]);
    }

    private static URL normalizeEntry(URL url) {
        String path;
        if (null != url && "jar".equals(url.getProtocol()) && (path = url.getPath()).endsWith("!/")) {
            try {
                return new URL(path.substring(0, path.length() - 2));
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e.toString());
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getClassPathEntries(URL url) throws IOException {
        String classPath;
        Manifest manifest;
        if (url.getPath().endsWith("/")) {
            try (InputStream in = Streams.open(new URL(url, MANIFEST_ENTRY));){
                manifest = new Manifest(in);
            }
        }
        if ("file".equals(url.getProtocol())) {
            try (JarFile jf = new JarFile(FileEntryIterator.toFile(url));){
                manifest = jf.getManifest();
            }
        }
        try (JarInputStream jin = new JarInputStream(Streams.open(url));){
            manifest = jin.getManifest();
        }
        if (null != manifest && null != (classPath = manifest.getMainAttributes().getValue("Class-Path"))) {
            return classPath.split(" ");
        }
        return EMPTY_CLASSPATH;
    }

    static {
        String classPath;
        ClassLoader systemLoader;
        try {
            systemLoader = ClassLoader.getSystemClassLoader();
            classPath = System.getProperty("java.class.path", ".");
        }
        catch (RuntimeException e) {
            systemLoader = null;
            classPath = null;
        }
        catch (LinkageError e) {
            systemLoader = null;
            classPath = null;
        }
        SYSTEM_LOADER = systemLoader;
        SYSTEM_CLASSPATH = classPath;
        NO_URLS = new URL[0];
        NO_ENTRIES = Collections.enumeration(Collections.emptySet());
        EMPTY_CLASSPATH = new String[0];
    }
}

