/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.sisu.wire;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.smithy.cli.shaded.eclipse.sisu.BeanEntry;
import software.amazon.smithy.cli.shaded.eclipse.sisu.Dynamic;
import software.amazon.smithy.cli.shaded.eclipse.sisu.Hidden;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.Legacy;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.Sources;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.TypeArguments;
import software.amazon.smithy.cli.shaded.eclipse.sisu.wire.BeanProviders;
import software.amazon.smithy.cli.shaded.eclipse.sisu.wire.GlueLoader;
import software.amazon.smithy.cli.shaded.eclipse.sisu.wire.Wiring;
import software.amazon.smithy.cli.shaded.google.inject.Binder;
import software.amazon.smithy.cli.shaded.google.inject.ImplementedBy;
import software.amazon.smithy.cli.shaded.google.inject.Key;
import software.amazon.smithy.cli.shaded.google.inject.ProvidedBy;
import software.amazon.smithy.cli.shaded.google.inject.Provider;
import software.amazon.smithy.cli.shaded.google.inject.TypeLiteral;
import software.amazon.smithy.cli.shaded.google.inject.name.Named;
import software.amazon.smithy.cli.shaded.google.inject.spi.InjectionPoint;

public final class LocatorWiring
implements Wiring {
    private static final Hidden HIDDEN_WIRING = Sources.hide(LocatorWiring.class.getName());
    private final BeanProviders beanProviders;
    private final Binder binder;

    public LocatorWiring(Binder binder) {
        this.beanProviders = new BeanProviders(binder);
        this.binder = binder.withSource((Object)HIDDEN_WIRING);
    }

    @Override
    public boolean wire(Key<?> key) {
        Class clazz = key.getTypeLiteral().getRawType();
        if (Map.class == clazz) {
            this.bindMapImport(key);
        } else if (List.class == clazz || Collection.class == clazz || Iterable.class == clazz) {
            this.bindListImport(key);
        } else if (Set.class == clazz) {
            this.bindSetImport(key);
        } else {
            this.bindBeanImport(key);
        }
        return true;
    }

    private void bindMapImport(Key key) {
        TypeLiteral<?>[] args = TypeArguments.get(key.getTypeLiteral());
        if (2 == args.length && null == key.getAnnotation()) {
            Class qualifierType = args[0].getRawType();
            if (String.class == qualifierType) {
                this.binder.bind(key).toProvider(this.beanProviders.stringMapOf(args[1]));
            } else if (qualifierType.isAnnotation()) {
                this.binder.bind(key).toProvider(this.beanProviders.mapOf(Key.get(args[1], (Class)qualifierType)));
            } else if (Annotation.class == qualifierType) {
                this.binder.bind(key).toProvider(this.beanProviders.mapOf(Key.get(args[1])));
            }
        }
    }

    private void bindListImport(Key key) {
        TypeLiteral<?>[] args = TypeArguments.get(key.getTypeLiteral());
        if (1 == args.length && null == key.getAnnotation()) {
            TypeLiteral<?> elementType = args[0];
            if (BeanEntry.class == elementType.getRawType() || software.amazon.smithy.cli.shaded.sonatype.inject.BeanEntry.class == elementType.getRawType()) {
                Provider beanEntriesProvider = this.getBeanEntriesProvider(elementType);
                if (null != beanEntriesProvider) {
                    this.binder.bind(key).toProvider(beanEntriesProvider);
                }
            } else {
                this.binder.bind(key).toProvider(this.beanProviders.listOf(Key.get(elementType)));
            }
        }
    }

    private Provider getBeanEntriesProvider(TypeLiteral entryType) {
        TypeLiteral<?>[] args = TypeArguments.get(entryType);
        if (2 == args.length) {
            Class qualifierType = args[0].getRawType();
            Key key = qualifierType.isAnnotation() ? Key.get(args[1], (Class)qualifierType) : Key.get(args[1]);
            Provider beanEntries = this.beanProviders.beanEntriesOf(key);
            return BeanEntry.class == entryType.getRawType() ? beanEntries : Legacy.adapt(beanEntries);
        }
        return null;
    }

    private void bindSetImport(Key key) {
        TypeLiteral<?>[] args = TypeArguments.get(key.getTypeLiteral());
        if (1 == args.length && null == key.getAnnotation()) {
            this.binder.bind(key).toProvider(this.beanProviders.setOf(Key.get(args[0])));
        }
    }

    private <T> void bindBeanImport(Key<T> key) {
        Annotation qualifier = key.getAnnotation();
        if (qualifier instanceof Named) {
            if (((Named)qualifier).value().length() == 0) {
                this.binder.bind(key).toProvider(this.beanProviders.firstOf(Key.get((TypeLiteral)key.getTypeLiteral(), Named.class)));
            } else {
                this.binder.bind(key).toProvider(this.beanProviders.placeholderOf(key));
            }
        } else if (qualifier instanceof Dynamic) {
            Provider delegate = this.beanProviders.firstOf(Key.get((TypeLiteral)key.getTypeLiteral()));
            this.binder.bind(key).toInstance(GlueLoader.dynamicGlue(key.getTypeLiteral(), delegate));
        } else {
            this.binder.bind(key).toProvider(this.beanProviders.firstOf(key));
            if (null == key.getAnnotationType()) {
                this.bindImplicitType(key.getTypeLiteral());
            }
        }
    }

    private void bindImplicitType(TypeLiteral type) {
        try {
            Class clazz = type.getRawType();
            if (TypeArguments.isConcrete(clazz)) {
                Member ctor = InjectionPoint.forConstructorOf((TypeLiteral)type).getMember();
                this.binder.bind(TypeArguments.implicitKey(clazz)).toConstructor((Constructor)ctor);
            } else {
                ImplementedBy implementedBy = clazz.getAnnotation(ImplementedBy.class);
                if (null != implementedBy) {
                    this.binder.bind(TypeArguments.implicitKey(clazz)).to(implementedBy.value());
                } else {
                    ProvidedBy providedBy = clazz.getAnnotation(ProvidedBy.class);
                    if (null != providedBy) {
                        this.binder.bind(TypeArguments.implicitKey(clazz)).toProvider(providedBy.value());
                    }
                }
            }
        }
        catch (RuntimeException runtimeException) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
    }
}

