/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.sisu.launch;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.Logs;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.ClassSpace;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.ClassVisitor;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.IndexedClassFinder;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.SpaceModule;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.SpaceVisitor;
import software.amazon.smithy.cli.shaded.eclipse.sisu.wire.WireModule;
import software.amazon.smithy.cli.shaded.eclipse.sisu.wire.Wiring;
import software.amazon.smithy.cli.shaded.google.inject.Binder;
import software.amazon.smithy.cli.shaded.google.inject.Key;
import software.amazon.smithy.cli.shaded.google.inject.Module;

public final class SisuExtensions
implements SpaceModule.Strategy,
WireModule.Strategy {
    private final ClassSpace space;
    private final boolean global;

    private SisuExtensions(ClassSpace space, boolean global) {
        this.space = space;
        this.global = global;
    }

    public static SisuExtensions local(ClassSpace space) {
        return new SisuExtensions(space, false);
    }

    public static SisuExtensions global(ClassSpace space) {
        return new SisuExtensions(space, true);
    }

    public void install(Binder binder) {
        this.install(binder, null, null);
    }

    public <C> void install(Binder binder, Class<C> contextType, C context) {
        for (Module m : this.create(Module.class, contextType, context)) {
            binder.install(m);
        }
    }

    @Override
    public Wiring wiring(Binder binder) {
        final Wiring defaultWiring = WireModule.Strategy.DEFAULT.wiring(binder);
        final List<Wiring> customWiring = this.create(Wiring.class, Binder.class, binder);
        return customWiring.isEmpty() ? defaultWiring : new Wiring(){

            @Override
            public boolean wire(Key<?> key) {
                for (Wiring w : customWiring) {
                    if (!w.wire(key)) continue;
                    return true;
                }
                return defaultWiring.wire(key);
            }
        };
    }

    @Override
    public SpaceVisitor visitor(Binder binder) {
        final SpaceVisitor defaultVisitor = SpaceModule.Strategy.DEFAULT.visitor(binder);
        final List<SpaceVisitor> customVisitors = this.create(SpaceVisitor.class, Binder.class, binder);
        return customVisitors.isEmpty() ? defaultVisitor : new SpaceVisitor(){

            @Override
            public void enterSpace(ClassSpace _space) {
                for (SpaceVisitor v : customVisitors) {
                    v.enterSpace(_space);
                }
                defaultVisitor.enterSpace(_space);
            }

            @Override
            public ClassVisitor visitClass(URL url) {
                for (SpaceVisitor v : customVisitors) {
                    ClassVisitor cv = v.visitClass(url);
                    if (null == cv) continue;
                    return cv;
                }
                return defaultVisitor.visitClass(url);
            }

            @Override
            public void leaveSpace() {
                for (SpaceVisitor v : customVisitors) {
                    v.leaveSpace();
                }
                defaultVisitor.leaveSpace();
            }
        };
    }

    public <T> List<T> create(Class<T> spi) {
        return this.create(spi, null, null);
    }

    public <T, C> List<T> create(Class<T> spi, Class<C> contextType, C context) {
        ArrayList<Object> extensions = new ArrayList<Object>();
        for (Class<T> impl : this.load(spi)) {
            try {
                Object instance = null;
                if (null != contextType) {
                    try {
                        instance = impl.getConstructor(contextType).newInstance(context);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                extensions.add(null != instance ? instance : (Object)impl.newInstance());
            }
            catch (Exception e) {
                Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
                Logs.debug("Problem creating: {}", impl, cause);
            }
            catch (LinkageError e) {
                Logs.debug("Problem creating: {}", impl, e);
            }
        }
        return extensions;
    }

    public <T> List<Class<? extends T>> load(Class<T> spi) {
        String index = "META-INF/services/" + spi.getName();
        ArrayList<Class<T>> extensionTypes = new ArrayList<Class<T>>();
        for (String name : new IndexedClassFinder(index, this.global).indexedNames(this.space)) {
            try {
                extensionTypes.add(this.space.loadClass(name).asSubclass(spi));
            }
            catch (Exception e) {
                Logs.debug("Problem loading: {}", name, e);
            }
            catch (LinkageError e) {
                Logs.debug("Problem loading: {}", name, e);
            }
        }
        return extensionTypes;
    }
}

