/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.sisu.inject;

import software.amazon.smithy.cli.shaded.eclipse.sisu.Hidden;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.BindingPublisher;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.Logs;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.Sources;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.TypeArguments;
import software.amazon.smithy.cli.shaded.google.inject.Binding;
import software.amazon.smithy.cli.shaded.google.inject.Injector;
import software.amazon.smithy.cli.shaded.google.inject.Key;
import software.amazon.smithy.cli.shaded.google.inject.TypeLiteral;

final class ImplicitBindings {
    private final Iterable<BindingPublisher> publishers;

    ImplicitBindings(Iterable<BindingPublisher> publishers) {
        this.publishers = publishers;
    }

    public <T> Binding<T> get(TypeLiteral<T> type) {
        Key implicitKey = TypeArguments.implicitKey(type.getRawType());
        for (BindingPublisher p : this.publishers) {
            Binding binding;
            Injector injector = p.adapt(Injector.class);
            if (null == injector || null == (binding = (Binding)injector.getBindings().get(implicitKey))) continue;
            Logs.trace("Using implicit binding: {} from: <>", binding, injector);
            return binding;
        }
        Key justInTimeKey = Key.get(type);
        for (BindingPublisher p : this.publishers) {
            Injector injector = p.adapt(Injector.class);
            if (null == injector) continue;
            try {
                Binding binding = injector.getBinding(justInTimeKey);
                if (null != Sources.getAnnotation(binding, Hidden.class)) continue;
                Logs.trace("Using just-in-time binding: {} from: <>", binding, injector);
                return binding;
            }
            catch (RuntimeException e) {
                Logs.debug("Problem with just-in-time binding: {}", justInTimeKey, e);
            }
            catch (LinkageError e) {
                Logs.debug("Problem with just-in-time binding: {}", justInTimeKey, e);
            }
        }
        return null;
    }
}

