/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.sisu.inject;

import java.lang.annotation.Annotation;
import software.amazon.smithy.cli.shaded.eclipse.sisu.Description;
import software.amazon.smithy.cli.shaded.eclipse.sisu.Priority;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.DeferredProvider;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.DescriptionSource;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.Guice4;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.PrioritySource;
import software.amazon.smithy.cli.shaded.google.inject.Binding;
import software.amazon.smithy.cli.shaded.google.inject.servlet.InstanceFilterBinding;
import software.amazon.smithy.cli.shaded.google.inject.servlet.InstanceServletBinding;
import software.amazon.smithy.cli.shaded.google.inject.servlet.LinkedFilterBinding;
import software.amazon.smithy.cli.shaded.google.inject.servlet.LinkedServletBinding;
import software.amazon.smithy.cli.shaded.google.inject.servlet.ServletModuleTargetVisitor;
import software.amazon.smithy.cli.shaded.google.inject.spi.BindingTargetVisitor;
import software.amazon.smithy.cli.shaded.google.inject.spi.ConstructorBinding;
import software.amazon.smithy.cli.shaded.google.inject.spi.DefaultBindingTargetVisitor;
import software.amazon.smithy.cli.shaded.google.inject.spi.ExposedBinding;
import software.amazon.smithy.cli.shaded.google.inject.spi.InstanceBinding;
import software.amazon.smithy.cli.shaded.google.inject.spi.LinkedKeyBinding;
import software.amazon.smithy.cli.shaded.google.inject.spi.ProviderInstanceBinding;
import software.amazon.smithy.cli.shaded.google.inject.spi.ProviderKeyBinding;
import software.amazon.smithy.cli.shaded.google.inject.spi.UntargettedBinding;
import software.amazon.smithy.cli.shaded.javax.inject.Provider;

final class Implementations {
    private static final boolean HAS_GUICE_SERVLET;
    private static final boolean HAS_JSR250_PRIORITY;

    private Implementations() {
    }

    public static Class<?> find(Binding<?> binding) {
        return (Class)binding.acceptTargetVisitor(ClassFinder.THIS);
    }

    public static <T extends Annotation> T getAnnotation(Binding<?> binding, Class<T> annotationType) {
        boolean isPriority = Priority.class.equals(annotationType);
        Class annotationSource = (Class)binding.acceptTargetVisitor(isPriority ? (HAS_GUICE_SERVLET ? ServletFinder.THIS : ProviderFinder.THIS) : ClassFinder.THIS);
        T annotation = null;
        if (null != annotationSource && null == (annotation = (T)annotationSource.getAnnotation(annotationType))) {
            if (HAS_JSR250_PRIORITY && isPriority) {
                annotation = Implementations.adaptJsr250(binding, annotationSource);
            } else if (Description.class.equals(annotationType)) {
                annotation = Implementations.adaptLegacy(binding, annotationSource);
            }
        }
        return annotation;
    }

    private static <T extends Annotation> T adaptJsr250(Binding<?> binding, Class<?> clazz) {
        software.amazon.smithy.cli.shaded.javax.annotation.Priority jsr250 = clazz.getAnnotation(software.amazon.smithy.cli.shaded.javax.annotation.Priority.class);
        return (T)(null != jsr250 ? new PrioritySource(binding.getSource(), jsr250.value()) : null);
    }

    private static <T extends Annotation> T adaptLegacy(Binding<?> binding, Class<?> clazz) {
        software.amazon.smithy.cli.shaded.sonatype.inject.Description legacy = clazz.getAnnotation(software.amazon.smithy.cli.shaded.sonatype.inject.Description.class);
        return (T)(null != legacy ? new DescriptionSource(binding.getSource(), legacy.value()) : null);
    }

    static {
        boolean hasJsr250Priority;
        boolean hasGuiceServlet;
        try {
            hasGuiceServlet = BindingTargetVisitor.class.isInstance(ServletFinder.THIS);
        }
        catch (LinkageError e) {
            hasGuiceServlet = false;
        }
        HAS_GUICE_SERVLET = hasGuiceServlet;
        try {
            hasJsr250Priority = software.amazon.smithy.cli.shaded.javax.annotation.Priority.class.isAnnotation();
        }
        catch (LinkageError e) {
            hasJsr250Priority = false;
        }
        HAS_JSR250_PRIORITY = hasJsr250Priority;
    }

    static class ClassFinder
    extends DefaultBindingTargetVisitor<Object, Class<?>> {
        static final BindingTargetVisitor<Object, Class<?>> THIS = new ClassFinder();

        ClassFinder() {
        }

        public Class<?> visit(UntargettedBinding<?> binding) {
            return binding.getKey().getTypeLiteral().getRawType();
        }

        public Class<?> visit(LinkedKeyBinding<?> binding) {
            return binding.getLinkedKey().getTypeLiteral().getRawType();
        }

        public Class<?> visit(ConstructorBinding<?> binding) {
            return binding.getConstructor().getDeclaringType().getRawType();
        }

        public Class<?> visit(InstanceBinding<?> binding) {
            return binding.getInstance().getClass();
        }

        public Class<?> visit(ProviderInstanceBinding<?> binding) {
            return this.peekBehind(Guice4.getProviderInstance(binding));
        }

        public Class<?> visit(ExposedBinding<?> binding) {
            return (Class)binding.getPrivateElements().getInjector().getBinding(binding.getKey()).acceptTargetVisitor((BindingTargetVisitor)this);
        }

        final Class<?> peekBehind(Provider<?> provider) {
            if (provider instanceof DeferredProvider) {
                try {
                    return ((DeferredProvider)((Object)provider)).getImplementationClass().load();
                }
                catch (TypeNotPresentException typeNotPresentException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    static final class ServletFinder
    extends ProviderFinder
    implements ServletModuleTargetVisitor<Object, Class<?>> {
        static final BindingTargetVisitor<Object, Class<?>> THIS = new ServletFinder();

        ServletFinder() {
        }

        public Class<?> visit(InstanceFilterBinding binding) {
            return binding.getFilterInstance().getClass();
        }

        public Class<?> visit(InstanceServletBinding binding) {
            return binding.getServletInstance().getClass();
        }

        public Class<?> visit(LinkedFilterBinding binding) {
            return binding.getLinkedKey().getTypeLiteral().getRawType();
        }

        public Class<?> visit(LinkedServletBinding binding) {
            return binding.getLinkedKey().getTypeLiteral().getRawType();
        }
    }

    static class ProviderFinder
    extends ClassFinder {
        static final BindingTargetVisitor<Object, Class<?>> THIS = new ProviderFinder();

        ProviderFinder() {
        }

        @Override
        public Class<?> visit(ProviderInstanceBinding<?> binding) {
            Provider<?> provider = Guice4.getProviderInstance(binding);
            Class<?> providedClass = this.peekBehind(provider);
            return null != providedClass ? providedClass : provider.getClass();
        }

        public Class<?> visit(ProviderKeyBinding<?> binding) {
            return binding.getProviderKey().getTypeLiteral().getRawType();
        }
    }
}

