/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.apache.http.impl.pool;

import java.util.concurrent.atomic.AtomicLong;
import software.amazon.smithy.cli.shaded.apache.http.HttpClientConnection;
import software.amazon.smithy.cli.shaded.apache.http.HttpHost;
import software.amazon.smithy.cli.shaded.apache.http.annotation.Contract;
import software.amazon.smithy.cli.shaded.apache.http.annotation.ThreadingBehavior;
import software.amazon.smithy.cli.shaded.apache.http.config.ConnectionConfig;
import software.amazon.smithy.cli.shaded.apache.http.config.SocketConfig;
import software.amazon.smithy.cli.shaded.apache.http.impl.pool.BasicConnFactory;
import software.amazon.smithy.cli.shaded.apache.http.impl.pool.BasicPoolEntry;
import software.amazon.smithy.cli.shaded.apache.http.params.HttpParams;
import software.amazon.smithy.cli.shaded.apache.http.pool.AbstractConnPool;
import software.amazon.smithy.cli.shaded.apache.http.pool.ConnFactory;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class BasicConnPool
extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();

    public BasicConnPool(ConnFactory<HttpHost, HttpClientConnection> connFactory) {
        super(connFactory, 2, 20);
    }

    @Deprecated
    public BasicConnPool(HttpParams params) {
        super(new BasicConnFactory(params), 2, 20);
    }

    public BasicConnPool(SocketConfig sconfig, ConnectionConfig cconfig) {
        super(new BasicConnFactory(sconfig, cconfig), 2, 20);
    }

    public BasicConnPool() {
        super(new BasicConnFactory(SocketConfig.DEFAULT, ConnectionConfig.DEFAULT), 2, 20);
    }

    @Override
    protected BasicPoolEntry createEntry(HttpHost host, HttpClientConnection conn) {
        return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), host, conn);
    }

    @Override
    protected boolean validate(BasicPoolEntry entry) {
        return !((HttpClientConnection)entry.getConnection()).isStale();
    }
}

