/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.concurrent.atomic.AtomicInteger;
import software.amazon.smithy.cli.ColorBuffer;
import software.amazon.smithy.cli.ColorTheme;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.Style;
import software.amazon.smithy.utils.StringUtils;

interface ProgressStyle {
    public void updateAction(Command.Env var1, AtomicInteger var2);

    public void closeAction(Command.Env var1);

    public static ColorBuffer getBuffer(Command.Env env) {
        return ColorBuffer.of(env.colors(), env.stdout());
    }

    public static ProgressStyle dots(final String progressMessage, final String closeMessage) {
        return new ProgressStyle(){
            private static final String PROGRESS_CHAR = ".";
            private static final int TICKER_LENGTH = 3;
            private final long startTimeMillis = System.currentTimeMillis();

            @Override
            public void updateAction(Command.Env env, AtomicInteger tracker) {
                int tickCount = tracker.getAndIncrement();
                int tickNumber = tickCount % 4;
                String loadStr = StringUtils.repeat((String)PROGRESS_CHAR, (int)tickNumber) + StringUtils.repeat((String)" ", (int)(3 - tickNumber));
                try (ColorBuffer buffer = ProgressStyle.getBuffer(env);){
                    buffer.print("\r", new Style[0]).print(progressMessage, ColorTheme.NOTE).print(loadStr, ColorTheme.NOTE);
                }
            }

            @Override
            public void closeAction(Command.Env env) {
                try (ColorBuffer buffer = ProgressStyle.getBuffer(env);){
                    buffer.print("\r", new Style[0]).print(closeMessage, ColorTheme.SUCCESS).print(" [", ColorTheme.MUTED).print((double)(System.currentTimeMillis() - this.startTimeMillis) / 1000.0 + "s", ColorTheme.NOTE).print("]", ColorTheme.MUTED).println();
                }
            }
        };
    }
}

