/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Logger;
import software.amazon.smithy.build.model.MavenConfig;
import software.amazon.smithy.build.model.MavenRepository;
import software.amazon.smithy.build.model.SmithyBuildConfig;
import software.amazon.smithy.cli.EnvironmentVariable;

final class ConfigurationUtils {
    private static final int FNV_OFFSET_BIAS = -2128831035;
    private static final int FNV_PRIME = 16777619;
    private static final Logger LOGGER = Logger.getLogger(ConfigurationUtils.class.getName());
    private static final MavenRepository CENTRAL = MavenRepository.builder().url("https://repo.maven.apache.org/maven2").build();

    private ConfigurationUtils() {
    }

    public static Set<MavenRepository> getConfiguredMavenRepos(SmithyBuildConfig config) {
        Set configuredRepos;
        LinkedHashSet<MavenRepository> repositories = new LinkedHashSet<MavenRepository>();
        String envRepos = EnvironmentVariable.SMITHY_MAVEN_REPOS.get();
        if (envRepos != null) {
            for (String repo : envRepos.split("\\|")) {
                repositories.add(MavenRepository.builder().url(repo.trim()).build());
            }
        }
        if (!(configuredRepos = config.getMaven().map(MavenConfig::getRepositories).orElse(Collections.emptySet())).isEmpty()) {
            repositories.addAll(configuredRepos);
        } else if (envRepos == null) {
            LOGGER.finest(() -> String.format("maven.repositories is not defined in `smithy-build.json` and the %s environment variable is not set. Defaulting to Maven Central.", new Object[]{EnvironmentVariable.SMITHY_MAVEN_REPOS}));
            repositories.add(CENTRAL);
        }
        return repositories;
    }

    public static int configHash(Set<String> artifacts, Set<MavenRepository> repositories) {
        int result = 0;
        for (String artifact : artifacts) {
            result = 31 * result + ConfigurationUtils.getFnvHash(artifact);
        }
        for (MavenRepository repo : repositories) {
            result = 31 * result + ConfigurationUtils.getFnvHash(repo.getUrl());
        }
        return result;
    }

    private static int getFnvHash(CharSequence text) {
        int hashCode = -2128831035;
        for (int i = 0; i < text.length(); ++i) {
            hashCode = (hashCode ^ text.charAt(i)) * 16777619;
        }
        return hashCode;
    }
}

