/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import software.amazon.smithy.cli.ArgumentReceiver;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliError;

final class DefaultArguments
implements Arguments {
    private final String[] args;
    private final Map<Class<? extends ArgumentReceiver>, ArgumentReceiver> receivers = new LinkedHashMap<Class<? extends ArgumentReceiver>, ArgumentReceiver>();
    private List<String> positional;
    private boolean inPositional = false;
    private int position = 0;

    DefaultArguments(String[] args) {
        this.args = args;
    }

    @Override
    public void addReceiver(ArgumentReceiver receiver) {
        this.receivers.put(receiver.getClass(), receiver);
    }

    @Override
    public boolean hasReceiver(Class<? extends ArgumentReceiver> receiverClass) {
        return this.receivers.containsKey(receiverClass);
    }

    @Override
    public <T extends ArgumentReceiver> T getReceiver(Class<T> type) {
        return (T)Objects.requireNonNull(this.receivers.get(type));
    }

    @Override
    public Iterable<ArgumentReceiver> getReceivers() {
        return this.receivers.values();
    }

    @Override
    public boolean hasNext() {
        return this.position < this.args.length;
    }

    @Override
    public String peek() {
        String peek;
        String string = peek = this.hasNext() ? this.args[this.position] : null;
        if (peek != null && !this.inPositional) {
            if (peek.equals("--")) {
                this.inPositional = true;
                ++this.position;
                return this.peek();
            }
            for (ArgumentReceiver interceptor : this.receivers.values()) {
                if (interceptor.testOption(peek)) {
                    ++this.position;
                    return this.peek();
                }
                Consumer<String> optionConsumer = interceptor.testParameter(peek);
                if (optionConsumer == null) continue;
                ++this.position;
                optionConsumer.accept(this.shiftFor(peek));
                return this.peek();
            }
        }
        return peek;
    }

    @Override
    public String shift() {
        String peek = this.peek();
        if (peek != null) {
            ++this.position;
        }
        return peek;
    }

    @Override
    public String shiftFor(String parameter) {
        if (!this.hasNext()) {
            throw new CliError("Expected argument for '" + parameter + "'");
        }
        String next = this.args[this.position];
        ++this.position;
        return next;
    }

    @Override
    public List<String> getPositional() {
        if (this.positional == null) {
            this.positional = new ArrayList<String>();
            while (this.hasNext()) {
                String next = this.shift();
                if (next == null) continue;
                if (!this.inPositional && next.startsWith("-")) {
                    throw new CliError("Unexpected CLI argument: " + next);
                }
                this.inPositional = true;
                this.positional.add(next);
            }
        }
        return this.positional;
    }
}

