/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.sisu.wire;

import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.Logs;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.TypeArguments;
import software.amazon.smithy.cli.shaded.google.inject.Binding;
import software.amazon.smithy.cli.shaded.google.inject.Key;
import software.amazon.smithy.cli.shaded.google.inject.TypeLiteral;
import software.amazon.smithy.cli.shaded.google.inject.spi.DefaultBindingTargetVisitor;
import software.amazon.smithy.cli.shaded.google.inject.spi.InjectionPoint;
import software.amazon.smithy.cli.shaded.google.inject.spi.LinkedKeyBinding;
import software.amazon.smithy.cli.shaded.google.inject.spi.UntargettedBinding;

final class DependencyVerifier
extends DefaultBindingTargetVisitor<Object, Boolean> {
    DependencyVerifier() {
    }

    public Boolean visit(UntargettedBinding<?> binding) {
        return DependencyVerifier.verifyImplementation(binding.getKey().getTypeLiteral());
    }

    public Boolean visit(LinkedKeyBinding<?> binding) {
        Key linkedKey = binding.getLinkedKey();
        if (linkedKey.getAnnotationType() == null) {
            return DependencyVerifier.verifyImplementation(linkedKey.getTypeLiteral());
        }
        return Boolean.TRUE;
    }

    public Boolean visitOther(Binding<?> binding) {
        return Boolean.TRUE;
    }

    private static Boolean verifyImplementation(TypeLiteral<?> type) {
        if (TypeArguments.isConcrete(type) && !type.toString().startsWith("java")) {
            try {
                InjectionPoint.forInstanceMethodsAndFields(type);
                InjectionPoint.forConstructorOf(type);
            }
            catch (RuntimeException e) {
                Logs.debug("Potential problem: {}", type, e);
                return Boolean.FALSE;
            }
            catch (LinkageError e) {
                Logs.debug("Potential problem: {}", type, e);
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }
}

