/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.sisu.osgi;

import java.lang.annotation.Annotation;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.BindingSubscriber;
import software.amazon.smithy.cli.shaded.google.inject.Binder;
import software.amazon.smithy.cli.shaded.google.inject.Binding;
import software.amazon.smithy.cli.shaded.google.inject.Key;
import software.amazon.smithy.cli.shaded.google.inject.Provider;
import software.amazon.smithy.cli.shaded.google.inject.Singleton;
import software.amazon.smithy.cli.shaded.google.inject.name.Names;
import software.amazon.smithy.cli.shaded.google.inject.spi.BindingScopingVisitor;
import software.amazon.smithy.cli.shaded.google.inject.spi.BindingTargetVisitor;
import software.amazon.smithy.cli.shaded.google.inject.spi.ElementVisitor;

final class ServiceBinding<T>
implements Binding<T>,
Provider<T> {
    private final Key<T> key;
    private final T instance;
    private final int rank;

    ServiceBinding(BundleContext context, String clazzName, int maxRank, ServiceReference<T> reference) throws ClassNotFoundException {
        int serviceRanking;
        Class clazz = reference.getBundle().loadClass(clazzName);
        Object name = reference.getProperty("name");
        this.key = name instanceof String && ((String)name).length() > 0 ? Key.get((Class)clazz, (Annotation)Names.named((String)((String)name))) : Key.get((Class)clazz);
        this.instance = context.getService(reference);
        this.rank = maxRank > Integer.MIN_VALUE ? ((serviceRanking = ServiceBinding.getServiceRanking(reference)) < maxRank ? serviceRanking : maxRank) : Integer.MIN_VALUE;
    }

    public Key<T> getKey() {
        return this.key;
    }

    public Provider<T> getProvider() {
        return this;
    }

    public T get() {
        return this.instance;
    }

    public Object getSource() {
        return "OSGi service registry";
    }

    public void applyTo(Binder binder) {
    }

    public <V> V acceptVisitor(ElementVisitor<V> visitor) {
        return (V)visitor.visit((Binding)this);
    }

    public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
        return null;
    }

    public <V> V acceptScopingVisitor(BindingScopingVisitor<V> visitor) {
        return (V)visitor.visitScopeAnnotation(Singleton.class);
    }

    boolean isCompatibleWith(BindingSubscriber<T> subscriber) {
        return this.key.getTypeLiteral().getRawType().equals(subscriber.type().getRawType());
    }

    int rank() {
        return this.rank;
    }

    private static int getServiceRanking(ServiceReference<?> reference) {
        Object ranking = reference.getProperty("service.ranking");
        return ranking instanceof Integer ? (Integer)ranking : 0;
    }
}

