/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.sisu.launch;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.junit.After;
import org.junit.Before;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.MutableBeanLocator;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.BeanScanning;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.ClassSpace;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.SpaceModule;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.URLClassSpace;
import software.amazon.smithy.cli.shaded.eclipse.sisu.wire.ParameterKeys;
import software.amazon.smithy.cli.shaded.eclipse.sisu.wire.WireModule;
import software.amazon.smithy.cli.shaded.google.inject.Binder;
import software.amazon.smithy.cli.shaded.google.inject.Guice;
import software.amazon.smithy.cli.shaded.google.inject.Key;
import software.amazon.smithy.cli.shaded.google.inject.Module;
import software.amazon.smithy.cli.shaded.google.inject.name.Names;
import software.amazon.smithy.cli.shaded.javax.inject.Inject;

public abstract class InjectedTest
implements Module {
    private String basedir;
    @Inject
    private MutableBeanLocator locator;

    @Before
    @BeforeMethod
    @BeforeEach
    public void setUp() throws Exception {
        Guice.createInjector((Module[])new Module[]{new WireModule(new SetUpModule(), this.spaceModule())});
    }

    @After
    @AfterMethod
    @AfterEach
    public void tearDown() throws Exception {
        this.locator.clear();
    }

    public SpaceModule spaceModule() {
        return new SpaceModule(this.space(), this.scanning());
    }

    public ClassSpace space() {
        return new URLClassSpace(this.getClass().getClassLoader());
    }

    public BeanScanning scanning() {
        return BeanScanning.CACHE;
    }

    public void configure(Binder binder) {
    }

    public void configure(Properties properties) {
    }

    public final <T> T lookup(Class<T> type) {
        return this.lookup(Key.get(type));
    }

    public final <T> T lookup(Class<T> type, String name) {
        return this.lookup(type, (Annotation)Names.named((String)name));
    }

    public final <T> T lookup(Class<T> type, Class<? extends Annotation> qualifier) {
        return this.lookup(Key.get(type, qualifier));
    }

    public final <T> T lookup(Class<T> type, Annotation qualifier) {
        return this.lookup(Key.get(type, (Annotation)qualifier));
    }

    public final String getBasedir() {
        if (null == this.basedir) {
            this.basedir = System.getProperty("basedir", new File("").getAbsolutePath());
        }
        return this.basedir;
    }

    private <T> T lookup(Key<T> key) {
        Iterator i = this.locator.locate(key).iterator();
        return i.hasNext() ? (T)((Map.Entry)i.next()).getValue() : null;
    }

    final class SetUpModule
    implements Module {
        SetUpModule() {
        }

        public void configure(Binder binder) {
            binder.install((Module)InjectedTest.this);
            Properties properties = new Properties();
            properties.put("basedir", InjectedTest.this.getBasedir());
            InjectedTest.this.configure(properties);
            binder.bind(ParameterKeys.PROPERTIES).toInstance((Object)properties);
            binder.requestInjection((Object)InjectedTest.this);
        }
    }
}

