/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.sisu.launch;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.MutableBeanLocator;
import software.amazon.smithy.cli.shaded.eclipse.sisu.launch.SisuExtensions;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.BeanScanning;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.BundleClassSpace;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.ClassSpace;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.SpaceModule;
import software.amazon.smithy.cli.shaded.eclipse.sisu.wire.ParameterKeys;
import software.amazon.smithy.cli.shaded.eclipse.sisu.wire.WireModule;
import software.amazon.smithy.cli.shaded.google.inject.Binder;
import software.amazon.smithy.cli.shaded.google.inject.Module;

public class BundleModule
implements Module {
    protected final BundleClassSpace space;
    protected final SisuExtensions extensions;
    protected final MutableBeanLocator locator;

    public BundleModule(Bundle bundle, MutableBeanLocator locator) {
        this.space = new BundleClassSpace(bundle);
        this.extensions = SisuExtensions.local(this.space);
        this.locator = locator;
    }

    public void configure(Binder binder) {
        new WireModule(this.modules()).with(this.extensions).configure(binder);
    }

    protected Map<?, ?> getProperties() {
        return System.getProperties();
    }

    protected List<Module> modules() {
        return Arrays.asList(this.extensionsModule(), this.contextModule(), this.spaceModule());
    }

    protected Module extensionsModule() {
        return new Module(){

            public void configure(Binder binder) {
                BundleModule.this.extensions.install(binder, Bundle.class, BundleModule.this.space.getBundle());
            }
        };
    }

    protected Module contextModule() {
        return new Module(){

            public void configure(Binder binder) {
                binder.bind(MutableBeanLocator.class).toInstance((Object)BundleModule.this.locator);
                Bundle bundle = BundleModule.this.space.getBundle();
                binder.bind(ParameterKeys.PROPERTIES).toInstance(BundleModule.this.getProperties());
                binder.bind(BundleContext.class).toInstance((Object)bundle.getBundleContext());
            }
        };
    }

    protected Module spaceModule() {
        return new SpaceModule((ClassSpace)this.space, BeanScanning.select(this.getProperties())).with(this.extensions);
    }
}

