/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.aether.util.graph.visitor;

import java.io.File;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.smithy.cli.shaded.eclipse.aether.artifact.Artifact;
import software.amazon.smithy.cli.shaded.eclipse.aether.graph.Dependency;
import software.amazon.smithy.cli.shaded.eclipse.aether.graph.DependencyNode;
import software.amazon.smithy.cli.shaded.eclipse.aether.graph.DependencyVisitor;

abstract class AbstractDepthFirstNodeListGenerator
implements DependencyVisitor {
    private final Map<DependencyNode, Object> visitedNodes;
    protected final List<DependencyNode> nodes = new ArrayList<DependencyNode>(128);

    AbstractDepthFirstNodeListGenerator() {
        this.visitedNodes = new IdentityHashMap<DependencyNode, Object>(512);
    }

    public List<DependencyNode> getNodes() {
        return this.nodes;
    }

    public List<Dependency> getDependencies(boolean includeUnresolved) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>(this.getNodes().size());
        for (DependencyNode node : this.getNodes()) {
            Dependency dependency = node.getDependency();
            if (dependency == null || !includeUnresolved && dependency.getArtifact().getFile() == null) continue;
            dependencies.add(dependency);
        }
        return dependencies;
    }

    public List<Artifact> getArtifacts(boolean includeUnresolved) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(this.getNodes().size());
        for (DependencyNode node : this.getNodes()) {
            if (node.getDependency() == null) continue;
            Artifact artifact = node.getDependency().getArtifact();
            if (!includeUnresolved && artifact.getFile() == null) continue;
            artifacts.add(artifact);
        }
        return artifacts;
    }

    public List<File> getFiles() {
        ArrayList<File> files = new ArrayList<File>(this.getNodes().size());
        for (DependencyNode node : this.getNodes()) {
            File file;
            if (node.getDependency() == null || (file = node.getDependency().getArtifact().getFile()) == null) continue;
            files.add(file);
        }
        return files;
    }

    public String getClassPath() {
        StringBuilder buffer = new StringBuilder(1024);
        for (DependencyNode node : this.getNodes()) {
            Artifact artifact;
            if (node.getDependency() == null || (artifact = node.getDependency().getArtifact()).getFile() == null) continue;
            if (buffer.length() != 0) {
                buffer.append(File.pathSeparatorChar);
            }
            buffer.append(artifact.getFile().getAbsolutePath());
        }
        return buffer.toString();
    }

    protected boolean setVisited(DependencyNode node) {
        return this.visitedNodes.put(node, Boolean.TRUE) == null;
    }

    @Override
    public abstract boolean visitEnter(DependencyNode var1);

    @Override
    public abstract boolean visitLeave(DependencyNode var1);
}

