/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.apache.maven.model.plugin;

import java.util.List;
import software.amazon.smithy.cli.shaded.apache.maven.model.Build;
import software.amazon.smithy.cli.shaded.apache.maven.model.Model;
import software.amazon.smithy.cli.shaded.apache.maven.model.Plugin;
import software.amazon.smithy.cli.shaded.apache.maven.model.PluginExecution;
import software.amazon.smithy.cli.shaded.apache.maven.model.PluginManagement;
import software.amazon.smithy.cli.shaded.apache.maven.model.building.ModelBuildingRequest;
import software.amazon.smithy.cli.shaded.apache.maven.model.building.ModelProblemCollector;
import software.amazon.smithy.cli.shaded.apache.maven.model.plugin.PluginConfigurationExpander;
import software.amazon.smithy.cli.shaded.codehaus.plexus.util.xml.Xpp3Dom;
import software.amazon.smithy.cli.shaded.javax.inject.Named;
import software.amazon.smithy.cli.shaded.javax.inject.Singleton;

@Named
@Singleton
public class DefaultPluginConfigurationExpander
implements PluginConfigurationExpander {
    @Override
    public void expandPluginConfiguration(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        Build build = model.getBuild();
        if (build != null) {
            this.expand(build.getPlugins());
            PluginManagement pluginManagement = build.getPluginManagement();
            if (pluginManagement != null) {
                this.expand(pluginManagement.getPlugins());
            }
        }
    }

    private void expand(List<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            Xpp3Dom pluginConfiguration = (Xpp3Dom)plugin.getConfiguration();
            if (pluginConfiguration == null) continue;
            for (PluginExecution execution : plugin.getExecutions()) {
                Xpp3Dom executionConfiguration = (Xpp3Dom)execution.getConfiguration();
                executionConfiguration = Xpp3Dom.mergeXpp3Dom(executionConfiguration, new Xpp3Dom(pluginConfiguration));
                execution.setConfiguration(executionConfiguration);
            }
        }
    }
}

