/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.sisu.space;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.Logs;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.ClassFinder;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.ClassSpace;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.Streams;

public final class IndexedClassFinder
implements ClassFinder {
    private final String localPath;
    private final String indexName;

    public IndexedClassFinder(String name, boolean global) {
        if (global) {
            this.localPath = null;
            this.indexName = name;
        } else {
            int i = name.lastIndexOf(47) + 1;
            this.localPath = name.substring(0, i);
            this.indexName = name.substring(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<String> indexedNames(ClassSpace space) {
        Enumeration<URL> indices = null == this.localPath ? space.getResources(this.indexName) : space.findEntries(this.localPath, this.indexName, false);
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        while (indices.hasMoreElements()) {
            URL url = indices.nextElement();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Streams.open(url), "UTF-8"));){
                String line = reader.readLine();
                while (line != null) {
                    String name;
                    int i = line.indexOf(35);
                    if (i != 0 && !(name = (i < 0 ? line : line.substring(0, i)).trim()).isEmpty()) {
                        names.add(name);
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                Logs.warn("Problem reading: {}", url, e);
            }
        }
        return names;
    }

    @Override
    public Enumeration<URL> findClasses(final ClassSpace space) {
        final Iterator<String> itr = this.indexedNames(space).iterator();
        return new Enumeration<URL>(){
            private URL nextURL;

            @Override
            public boolean hasMoreElements() {
                while (null == this.nextURL && itr.hasNext()) {
                    this.nextURL = space.getResource(((String)itr.next()).replace('.', '/') + ".class");
                }
                return null != this.nextURL;
            }

            @Override
            public URL nextElement() {
                if (this.hasMoreElements()) {
                    URL tempURL = this.nextURL;
                    this.nextURL = null;
                    return tempURL;
                }
                throw new NoSuchElementException();
            }
        };
    }
}

