/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.apache.maven.repository.internal;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import software.amazon.smithy.cli.shaded.apache.maven.repository.internal.PluginsMetadata;
import software.amazon.smithy.cli.shaded.codehaus.plexus.util.ReaderFactory;
import software.amazon.smithy.cli.shaded.codehaus.plexus.util.xml.XmlStreamReader;
import software.amazon.smithy.cli.shaded.codehaus.plexus.util.xml.Xpp3Dom;
import software.amazon.smithy.cli.shaded.codehaus.plexus.util.xml.Xpp3DomBuilder;
import software.amazon.smithy.cli.shaded.eclipse.aether.RepositorySystemSession;
import software.amazon.smithy.cli.shaded.eclipse.aether.artifact.Artifact;
import software.amazon.smithy.cli.shaded.eclipse.aether.deployment.DeployRequest;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.MetadataGenerator;
import software.amazon.smithy.cli.shaded.eclipse.aether.installation.InstallRequest;
import software.amazon.smithy.cli.shaded.eclipse.aether.metadata.Metadata;
import software.amazon.smithy.cli.shaded.eclipse.aether.util.ConfigUtils;
import software.amazon.smithy.cli.shaded.slf4j.Logger;
import software.amazon.smithy.cli.shaded.slf4j.LoggerFactory;

class PluginsMetadataGenerator
implements MetadataGenerator {
    private static final String PLUGIN_DESCRIPTOR_LOCATION = "META-INF/maven/plugin.xml";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<Object, PluginsMetadata> processedPlugins = new LinkedHashMap<Object, PluginsMetadata>();
    private final Date timestamp;

    PluginsMetadataGenerator(RepositorySystemSession session, InstallRequest request) {
        this(session, request.getMetadata());
    }

    PluginsMetadataGenerator(RepositorySystemSession session, DeployRequest request) {
        this(session, request.getMetadata());
    }

    private PluginsMetadataGenerator(RepositorySystemSession session, Collection<? extends Metadata> metadatas) {
        this.timestamp = (Date)ConfigUtils.getObject(session, (Object)new Date(), "maven.startTime");
        Iterator<? extends Metadata> it = metadatas.iterator();
        while (it.hasNext()) {
            Metadata metadata = it.next();
            if (!(metadata instanceof PluginsMetadata)) continue;
            it.remove();
            PluginsMetadata pluginMetadata = (PluginsMetadata)metadata;
            this.processedPlugins.put(pluginMetadata.getGroupId(), pluginMetadata);
        }
    }

    @Override
    public Collection<? extends Metadata> prepare(Collection<? extends Artifact> artifacts) {
        return Collections.emptyList();
    }

    @Override
    public Artifact transformArtifact(Artifact artifact) {
        return artifact;
    }

    @Override
    public Collection<? extends Metadata> finish(Collection<? extends Artifact> artifacts) {
        LinkedHashMap<String, PluginsMetadata> plugins = new LinkedHashMap<String, PluginsMetadata>();
        for (Artifact artifact : artifacts) {
            PluginsMetadata pluginMetadata;
            String key;
            PluginsMetadata.PluginInfo pluginInfo = this.extractPluginInfo(artifact);
            if (pluginInfo == null || this.processedPlugins.get(key = pluginInfo.groupId) != null || (pluginMetadata = (PluginsMetadata)plugins.get(key)) != null) continue;
            pluginMetadata = new PluginsMetadata(pluginInfo, this.timestamp);
            plugins.put(key, pluginMetadata);
        }
        return plugins.values();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PluginsMetadata.PluginInfo extractPluginInfo(Artifact artifact) {
        if (artifact == null) return null;
        if (!"jar".equals(artifact.getExtension())) return null;
        if (!"".equals(artifact.getClassifier())) return null;
        if (artifact.getFile() == null) return null;
        Path artifactPath = artifact.getFile().toPath();
        if (!Files.isRegularFile(artifactPath, new LinkOption[0])) return null;
        try (JarFile artifactJar = new JarFile(artifactPath.toFile(), false);){
            ZipEntry pluginDescriptorEntry = artifactJar.getEntry(PLUGIN_DESCRIPTOR_LOCATION);
            if (pluginDescriptorEntry == null) return null;
            try (XmlStreamReader reader = ReaderFactory.newXmlReader(artifactJar.getInputStream(pluginDescriptorEntry));){
                Xpp3Dom root = Xpp3DomBuilder.build(reader);
                String groupId = PluginsMetadataGenerator.mayGetChild(root, "groupId");
                String artifactId = PluginsMetadataGenerator.mayGetChild(root, "artifactId");
                String goalPrefix = PluginsMetadataGenerator.mayGetChild(root, "goalPrefix");
                String name = PluginsMetadataGenerator.mayGetChild(root, "name");
                if (Objects.equals(artifact.getGroupId(), groupId) && Objects.equals(artifact.getArtifactId(), artifactId)) {
                    PluginsMetadata.PluginInfo pluginInfo = new PluginsMetadata.PluginInfo(groupId, artifactId, goalPrefix, name);
                    return pluginInfo;
                }
                this.logger.warn("Artifact {}:{} JAR (about to be installed/deployed) contains Maven Plugin metadata for conflicting coordinates: {}:{}. Your JAR contains rogue Maven Plugin metadata. Possible causes may be: shaded into this JAR some Maven Plugin or some rogue resource.", artifact.getGroupId(), artifact.getArtifactId(), groupId, artifactId);
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String mayGetChild(Xpp3Dom node, String child) {
        Xpp3Dom c = node.getChild(child);
        if (c != null) {
            return c.getValue();
        }
        return null;
    }
}

