/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.sisu.inject;

import com.google.inject.Binding;
import com.google.inject.Singleton;
import software.amazon.smithy.cli.shaded.eclipse.sisu.Priority;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.QualifyingStrategy;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.RankingFunction;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.Sources;
import software.amazon.smithy.cli.shaded.javax.inject.Inject;

@Singleton
public final class DefaultRankingFunction
implements RankingFunction {
    private final int primaryRank;

    public DefaultRankingFunction(int primaryRank) {
        if (primaryRank < 0) {
            throw new IllegalArgumentException("Primary rank must be zero or more");
        }
        this.primaryRank = primaryRank;
    }

    @Inject
    public DefaultRankingFunction() {
        this(0);
    }

    @Override
    public int maxRank() {
        return Integer.MAX_VALUE;
    }

    @Override
    public <T> int rank(Binding<T> binding) {
        Priority priority = Sources.getAnnotation(binding, Priority.class);
        if (null != priority) {
            return priority.value();
        }
        if (QualifyingStrategy.DEFAULT_QUALIFIER.equals(QualifyingStrategy.qualify(binding.getKey()))) {
            return this.primaryRank;
        }
        return this.primaryRank + Integer.MIN_VALUE;
    }
}

