/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.apache.http.protocol;

import java.io.IOException;
import software.amazon.smithy.cli.shaded.apache.http.HttpEntityEnclosingRequest;
import software.amazon.smithy.cli.shaded.apache.http.HttpException;
import software.amazon.smithy.cli.shaded.apache.http.HttpRequest;
import software.amazon.smithy.cli.shaded.apache.http.HttpRequestInterceptor;
import software.amazon.smithy.cli.shaded.apache.http.annotation.Contract;
import software.amazon.smithy.cli.shaded.apache.http.annotation.ThreadingBehavior;
import software.amazon.smithy.cli.shaded.apache.http.protocol.HttpContext;
import software.amazon.smithy.cli.shaded.apache.http.protocol.HttpDateGenerator;
import software.amazon.smithy.cli.shaded.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

