/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.io.UncheckedIOException;
import java.nio.file.Paths;
import java.util.Collection;
import software.amazon.smithy.cli.ColorBuffer;
import software.amazon.smithy.cli.ColorFormatter;
import software.amazon.smithy.cli.ColorTheme;
import software.amazon.smithy.cli.Style;
import software.amazon.smithy.cli.commands.CodeFormatter;
import software.amazon.smithy.cli.commands.StyleHelper;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.sourcecontext.SourceContextLoader;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationEventFormatter;
import software.amazon.smithy.utils.SmithyBuilder;

final class PrettyAnsiValidationFormatter
implements ValidationEventFormatter {
    private static final int LINE_LENGTH = 80;
    private final SourceContextLoader sourceContextLoader;
    private final ColorFormatter colors;
    private final String rootPath = Paths.get("", new String[0]).normalize().toAbsolutePath().toString();
    private final String titleLabel;
    private final Style[] titleLabelStyles;

    PrettyAnsiValidationFormatter(Builder builder) {
        this.sourceContextLoader = (SourceContextLoader)SmithyBuilder.requiredState((String)"sourceContextLoader", (Object)builder.sourceContextLoader);
        this.colors = (ColorFormatter)SmithyBuilder.requiredState((String)"colors", (Object)builder.colors);
        this.titleLabel = (String)SmithyBuilder.requiredState((String)"titleLabel", (Object)builder.titleLabel);
        this.titleLabelStyles = builder.titleLabelStyles;
    }

    static Builder builder() {
        return new Builder();
    }

    public String format(ValidationEvent event) {
        String ls = System.lineSeparator();
        try (ColorBuffer writer = ColorBuffer.of(this.colors, new StringBuilder());){
            writer.append(ls);
            switch (event.getSeverity()) {
                case WARNING: {
                    this.printTitle(writer, event, ColorTheme.WARNING, ColorTheme.WARNING_TITLE);
                    break;
                }
                case ERROR: {
                    this.printTitle(writer, event, ColorTheme.ERROR, ColorTheme.ERROR_TITLE);
                    break;
                }
                case DANGER: {
                    this.printTitle(writer, event, ColorTheme.DANGER, ColorTheme.DANGER_TITLE);
                    break;
                }
                case NOTE: {
                    this.printTitle(writer, event, ColorTheme.NOTE, ColorTheme.NOTE_TITLE);
                    break;
                }
                default: {
                    this.printTitle(writer, event, ColorTheme.SUPPRESSED, ColorTheme.SUPPRESSED_TITLE);
                }
            }
            event.getShapeId().ifPresent(id -> {
                this.colors.style(writer, "Shape: ", ColorTheme.MUTED);
                this.colors.style(writer, id.toString(), ColorTheme.EVENT_SHAPE_ID);
                writer.append(ls);
            });
            if (event.getSourceLocation() == SourceLocation.NONE) {
                writer.append(ls);
            } else {
                String humanReadableFilename = this.getHumanReadableFilename(event.getSourceLocation().getFilename());
                int line = event.getSourceLocation().getLine();
                int column = event.getSourceLocation().getColumn();
                this.colors.style(writer, "File:  ", ColorTheme.MUTED);
                this.colors.style(writer, humanReadableFilename + ':' + line + ':' + column, ColorTheme.MUTED);
                writer.append(ls).append(ls);
                try {
                    Collection lines = this.sourceContextLoader.loadContext((FromSourceLocation)event);
                    if (!lines.isEmpty()) {
                        new CodeFormatter(writer, 80).writeCode(line, column, lines);
                    }
                }
                catch (UncheckedIOException e) {
                    this.colors.style(writer, "Invalid source file", ColorTheme.EM_UNDERLINE);
                    writer.append(": ");
                    this.writeMessage(writer, e.getCause().getMessage());
                    writer.append(ls).append(ls);
                }
            }
            this.writeMessage(writer, event.getMessage());
            writer.append(ls);
            event.getHint().ifPresent(hint -> {
                String hintLabel = "HINT: ";
                writer.append(ls);
                this.colors.style(writer, hintLabel, ColorTheme.HINT_TITLE);
                writer.append(StyleHelper.formatMessage(hint, 80 - hintLabel.length(), this.colors));
                writer.append(ls);
            });
            String string = writer.toString();
            return string;
        }
    }

    private void printTitle(ColorBuffer writer, ValidationEvent event, Style border, Style styles) {
        this.colors.style(writer, "\u2500\u2500 ", border);
        if (!this.titleLabel.isEmpty()) {
            this.colors.style(writer, ' ' + this.titleLabel + ' ', this.titleLabelStyles);
        }
        this.colors.style(writer, ' ' + event.getSeverity().toString() + ' ', styles);
        int prefixLength = 3 + (this.titleLabel.isEmpty() ? 0 : this.titleLabel.length() + 2) + 1 + event.getSeverity().toString().length() + 1 + 3 + 1;
        writer.style(w -> {
            w.append(" \u2500\u2500");
            int remainingLength = 80 - prefixLength;
            int padding = remainingLength - event.getId().length();
            for (int i = 0; i < padding; ++i) {
                w.append("\u2500");
            }
            w.append(' ');
        }, border);
        writer.append(event.getId()).append(System.lineSeparator());
    }

    private void writeMessage(ColorBuffer writer, String message) {
        writer.append(StyleHelper.formatMessage(message, 80, this.colors));
    }

    private String getHumanReadableFilename(String filename) {
        if (filename.startsWith("jar:")) {
            filename = filename.substring(4);
        }
        if (filename.startsWith("file:")) {
            filename = filename.substring(5);
        }
        if (filename.startsWith(this.rootPath)) {
            filename = filename.substring(this.rootPath.length() + 1);
        }
        return filename;
    }

    static final class Builder {
        private SourceContextLoader sourceContextLoader;
        private ColorFormatter colors;
        private String titleLabel = "";
        private Style[] titleLabelStyles;

        Builder() {
        }

        Builder sourceContextLoader(SourceContextLoader sourceContextLoader) {
            this.sourceContextLoader = sourceContextLoader;
            return this;
        }

        Builder colors(ColorFormatter colors) {
            this.colors = colors;
            return this;
        }

        Builder titleLabel(String titleLabel, Style ... styles) {
            this.titleLabel = titleLabel == null ? "" : titleLabel;
            this.titleLabelStyles = styles;
            return this;
        }

        PrettyAnsiValidationFormatter build() {
            return new PrettyAnsiValidationFormatter(this);
        }
    }
}

