/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.util.logging.Logger;

public enum EnvironmentVariable {
    SMITHY_MAVEN_CACHE,
    SMITHY_MAVEN_REPOS,
    SMITHY_DEPENDENCY_MODE{

        @Override
        public String get() {
            String result = super.get();
            if (result != null) {
                return result;
            }
            if (System.getProperty("org.gradle.appname") != null) {
                LOGGER.info("Detected that the Smithy CLI is running in Gradle, so dependency resolution is disabled. This can be overridden by setting SMITHY_DEPENDENCY_MODE environment variable to 'standard'.");
                return "ignore";
            }
            return "standard";
        }
    }
    ,
    SMITHY_VERSION,
    NO_COLOR,
    FORCE_COLOR,
    TERM,
    SMITHY_PROXY_HOST,
    SMITHY_PROXY_CREDENTIALS;

    private static final Logger LOGGER;

    public static String getByName(String name) {
        String value = System.getProperty(name);
        if (value == null) {
            value = System.getenv(name);
        }
        return value;
    }

    public boolean isSet() {
        return this.get() != null;
    }

    public String get() {
        return EnvironmentVariable.getByName(this.toString());
    }

    public void set(String value) {
        System.setProperty(this.toString(), value);
    }

    public void clear() {
        System.clearProperty(this.toString());
    }

    static {
        LOGGER = Logger.getLogger(EnvironmentVariable.class.getName());
    }
}

