/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.logging.Logger;
import software.amazon.smithy.build.model.SmithyBuildConfig;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.commands.BuildOptions;
import software.amazon.smithy.cli.commands.ClasspathAction;
import software.amazon.smithy.cli.commands.ConfigOptions;
import software.amazon.smithy.cli.commands.DiscoveryOptions;
import software.amazon.smithy.cli.commands.HelpActionWrapper;
import software.amazon.smithy.cli.commands.ModelBuilder;
import software.amazon.smithy.cli.commands.ValidationEventFormatOptions;
import software.amazon.smithy.cli.commands.ValidatorOptions;
import software.amazon.smithy.cli.dependencies.DependencyResolver;

final class ValidateCommand
implements Command {
    private static final Logger LOGGER = Logger.getLogger(ValidateCommand.class.getName());
    private final String parentCommandName;
    private final DependencyResolver.Factory dependencyResolverFactory;

    ValidateCommand(String parentCommandName, DependencyResolver.Factory dependencyResolverFactory) {
        this.parentCommandName = parentCommandName;
        this.dependencyResolverFactory = dependencyResolverFactory;
    }

    @Override
    public String getName() {
        return "validate";
    }

    @Override
    public String getSummary() {
        return "Validates Smithy models.";
    }

    @Override
    public int execute(Arguments arguments, Command.Env env) {
        arguments.addReceiver(new ConfigOptions());
        arguments.addReceiver(new DiscoveryOptions());
        arguments.addReceiver(new ValidatorOptions());
        arguments.addReceiver(new BuildOptions());
        arguments.addReceiver(new ValidationEventFormatOptions());
        HelpActionWrapper action = HelpActionWrapper.fromCommand(this, this.parentCommandName, new ClasspathAction(this.dependencyResolverFactory, this::runWithClassLoader));
        return action.apply(arguments, env);
    }

    private int runWithClassLoader(SmithyBuildConfig config, Arguments arguments, Command.Env env) {
        new ModelBuilder().config(config).arguments(arguments).env(env).models(arguments.getPositional()).validationPrinter(env.stdout()).build();
        LOGGER.info("Smithy validation complete");
        return 0;
    }
}

