/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.apache.http.impl.client;

import java.io.IOException;
import software.amazon.smithy.cli.shaded.apache.http.HttpEntity;
import software.amazon.smithy.cli.shaded.apache.http.HttpResponse;
import software.amazon.smithy.cli.shaded.apache.http.StatusLine;
import software.amazon.smithy.cli.shaded.apache.http.annotation.Contract;
import software.amazon.smithy.cli.shaded.apache.http.annotation.ThreadingBehavior;
import software.amazon.smithy.cli.shaded.apache.http.client.HttpResponseException;
import software.amazon.smithy.cli.shaded.apache.http.client.ResponseHandler;
import software.amazon.smithy.cli.shaded.apache.http.util.EntityUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public abstract class AbstractResponseHandler<T>
implements ResponseHandler<T> {
    @Override
    public T handleResponse(HttpResponse response) throws HttpResponseException, IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            EntityUtils.consume(entity);
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return entity == null ? null : (T)this.handleEntity(entity);
    }

    public abstract T handleEntity(HttpEntity var1) throws IOException;
}

