/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.apache.http.protocol;

import java.io.IOException;
import software.amazon.smithy.cli.shaded.apache.http.HttpEntity;
import software.amazon.smithy.cli.shaded.apache.http.HttpEntityEnclosingRequest;
import software.amazon.smithy.cli.shaded.apache.http.HttpException;
import software.amazon.smithy.cli.shaded.apache.http.HttpRequest;
import software.amazon.smithy.cli.shaded.apache.http.HttpRequestInterceptor;
import software.amazon.smithy.cli.shaded.apache.http.HttpVersion;
import software.amazon.smithy.cli.shaded.apache.http.ProtocolVersion;
import software.amazon.smithy.cli.shaded.apache.http.annotation.Contract;
import software.amazon.smithy.cli.shaded.apache.http.annotation.ThreadingBehavior;
import software.amazon.smithy.cli.shaded.apache.http.protocol.HttpContext;
import software.amazon.smithy.cli.shaded.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

