/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.smithy.cli.ArgumentReceiver;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.HelpPrinter;
import software.amazon.smithy.cli.StandardOptions;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;

final class ValidatorOptions
implements ArgumentReceiver {
    static final String SEVERITY = "--severity";
    static final String SHOW_VALIDATORS = "--show-validators";
    static final String HIDE_VALIDATORS = "--hide-validators";
    private Severity severity;
    private List<String> showValidators = Collections.emptyList();
    private List<String> hideValidators = Collections.emptyList();

    ValidatorOptions() {
    }

    @Override
    public void registerHelp(HelpPrinter printer) {
        printer.param(SEVERITY, null, "SEVERITY", "Set the minimum reported validation severity (one of NOTE, WARNING [default setting], DANGER, ERROR).");
        printer.param(SHOW_VALIDATORS, null, "VALIDATORS", "Comma-separated list of hierarchical validation event IDs to show in the output of the command, hiding the rest.");
        printer.param(HIDE_VALIDATORS, null, "VALIDATORS", "Comma-separated list of hierarchical validation event IDs to hide in the output of the command, showing the rest.");
    }

    @Override
    public Consumer<String> testParameter(String name) {
        switch (name) {
            case "--severity": {
                return value -> this.severity((Severity)Severity.fromString((String)value).orElseThrow(() -> new CliError("Invalid severity level: " + value)));
            }
            case "--show-validators": {
                return value -> {
                    if (!this.hideValidators.isEmpty()) {
                        throw new CliError("--show-validators and --hide-validators are mutually exclusive");
                    }
                    this.showValidators(this.parseIds((String)value));
                };
            }
            case "--hide-validators": {
                return value -> {
                    if (!this.showValidators.isEmpty()) {
                        throw new CliError("--show-validators and --hide-validators are mutually exclusive");
                    }
                    this.hideValidators(this.parseIds((String)value));
                };
            }
        }
        return null;
    }

    private List<String> parseIds(String value) {
        ArrayList<String> result = new ArrayList<String>();
        for (String id : value.split("\\s*,\\s*")) {
            if ((id = id.trim()).isEmpty()) {
                throw new CliError("Invalid validation event ID");
            }
            result.add(id);
        }
        return result;
    }

    Severity severity() {
        return this.severity;
    }

    void severity(Severity severity) {
        this.severity = severity;
    }

    Severity detectAndGetSeverity(StandardOptions standardOptions) {
        if (this.severity == null) {
            this.severity = standardOptions.quiet() ? Severity.DANGER : Severity.WARNING;
        }
        return this.severity;
    }

    void showValidators(List<String> validators) {
        this.showValidators = validators;
    }

    List<String> showValidators() {
        return this.showValidators;
    }

    List<String> hideValidators(String csv) {
        return this.hideValidators;
    }

    void hideValidators(List<String> validators) {
        this.hideValidators = validators;
    }

    boolean isVisible(ValidationEvent event) {
        if (event.getSeverity().ordinal() < this.severity.ordinal()) {
            return false;
        }
        if (!this.showValidators.isEmpty()) {
            for (String show : this.showValidators) {
                if (!event.containsId(show)) continue;
                return true;
            }
            return false;
        }
        if (!this.hideValidators.isEmpty()) {
            for (String hide : this.hideValidators) {
                if (!event.containsId(hide)) continue;
                return false;
            }
        }
        return true;
    }
}

