/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.synccontext;

import java.util.Objects;
import software.amazon.smithy.cli.shaded.eclipse.aether.RepositorySystemSession;
import software.amazon.smithy.cli.shaded.eclipse.aether.SyncContext;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.synccontext.named.NamedLockFactoryAdapter;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.synccontext.named.NamedLockFactoryAdapterFactory;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.locator.Service;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.locator.ServiceLocator;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.synccontext.SyncContextFactory;
import software.amazon.smithy.cli.shaded.javax.inject.Inject;
import software.amazon.smithy.cli.shaded.javax.inject.Named;
import software.amazon.smithy.cli.shaded.javax.inject.Singleton;

@Singleton
@Named
public final class DefaultSyncContextFactory
implements SyncContextFactory,
Service {
    private static final String ADAPTER_KEY = DefaultSyncContextFactory.class.getName() + ".adapter";
    private NamedLockFactoryAdapterFactory namedLockFactoryAdapterFactory;

    @Inject
    public DefaultSyncContextFactory(NamedLockFactoryAdapterFactory namedLockFactoryAdapterFactory) {
        this.namedLockFactoryAdapterFactory = Objects.requireNonNull(namedLockFactoryAdapterFactory);
    }

    @Deprecated
    public DefaultSyncContextFactory() {
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.namedLockFactoryAdapterFactory = Objects.requireNonNull(locator.getService(NamedLockFactoryAdapterFactory.class));
    }

    @Override
    public SyncContext newInstance(RepositorySystemSession session, boolean shared) {
        Objects.requireNonNull(session, "session cannot be null");
        NamedLockFactoryAdapter adapter = (NamedLockFactoryAdapter)session.getData().computeIfAbsent(ADAPTER_KEY, () -> this.namedLockFactoryAdapterFactory.getAdapter(session));
        return adapter.newInstance(session, shared);
    }
}

