/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.util.List;
import software.amazon.smithy.cli.Cli;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.EnvironmentVariable;
import software.amazon.smithy.cli.commands.SmithyCommand;
import software.amazon.smithy.cli.dependencies.DependencyResolver;
import software.amazon.smithy.cli.dependencies.MavenDependencyResolver;
import software.amazon.smithy.utils.IoUtils;

public final class SmithyCli {
    private ClassLoader classLoader;
    private DependencyResolver.Factory dependencyResolverFactory;

    private SmithyCli() {
    }

    public static SmithyCli create() {
        return new SmithyCli();
    }

    public static void main(String ... args) {
        try {
            int exitCode = SmithyCli.create().run(args);
            if (exitCode != 0) {
                System.exit(exitCode);
            }
        }
        catch (CliError e) {
            System.exit(e.code);
        }
        catch (Exception e) {
            System.exit(1);
        }
    }

    public SmithyCli classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public SmithyCli dependencyResolverFactory(DependencyResolver.Factory dependencyResolverFactory) {
        this.dependencyResolverFactory = dependencyResolverFactory;
        return this;
    }

    public int run(List<String> args) {
        return this.run(args.toArray(new String[0]));
    }

    public int run(String ... args) {
        return this.createCli().run(args);
    }

    public Cli createCli() {
        if (this.dependencyResolverFactory == null) {
            this.dependencyResolverFactory = (config, env) -> new MavenDependencyResolver(EnvironmentVariable.SMITHY_MAVEN_CACHE.get());
        }
        return new Cli(new SmithyCommand(this.dependencyResolverFactory), this.classLoader);
    }

    public static String getVersion() {
        return IoUtils.readUtf8Resource(SmithyCli.class, (String)"cli-version").trim();
    }
}

