/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl;

import java.util.Objects;
import java.util.regex.Pattern;
import software.amazon.smithy.cli.shaded.eclipse.aether.RepositorySystemSession;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.OfflineController;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.RemoteRepository;
import software.amazon.smithy.cli.shaded.eclipse.aether.transfer.RepositoryOfflineException;
import software.amazon.smithy.cli.shaded.eclipse.aether.util.ConfigUtils;
import software.amazon.smithy.cli.shaded.javax.inject.Named;
import software.amazon.smithy.cli.shaded.javax.inject.Singleton;

@Singleton
@Named
public class DefaultOfflineController
implements OfflineController {
    static final String CONFIG_PROP_OFFLINE_PROTOCOLS = "aether.offline.protocols";
    static final String CONFIG_PROP_OFFLINE_HOSTS = "aether.offline.hosts";
    private static final Pattern SEP = Pattern.compile("\\s*,\\s*");

    @Override
    public void checkOffline(RepositorySystemSession session, RemoteRepository repository) throws RepositoryOfflineException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        if (this.isOfflineProtocol(session, repository) || this.isOfflineHost(session, repository)) {
            return;
        }
        throw new RepositoryOfflineException(repository);
    }

    private boolean isOfflineProtocol(RepositorySystemSession session, RemoteRepository repository) {
        String protocol;
        String[] protocols = this.getConfig(session, CONFIG_PROP_OFFLINE_PROTOCOLS);
        if (protocols != null && (protocol = repository.getProtocol()).length() > 0) {
            for (String p : protocols) {
                if (!p.equalsIgnoreCase(protocol)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isOfflineHost(RepositorySystemSession session, RemoteRepository repository) {
        String host;
        String[] hosts = this.getConfig(session, CONFIG_PROP_OFFLINE_HOSTS);
        if (hosts != null && (host = repository.getHost()).length() > 0) {
            for (String h : hosts) {
                if (!h.equalsIgnoreCase(host)) continue;
                return true;
            }
        }
        return false;
    }

    private String[] getConfig(RepositorySystemSession session, String key) {
        String value = ConfigUtils.getString(session, "", key).trim();
        if (value.isEmpty()) {
            return null;
        }
        return SEP.split(value);
    }
}

