/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.apache.maven.repository.internal;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import software.amazon.smithy.cli.shaded.apache.maven.model.DistributionManagement;
import software.amazon.smithy.cli.shaded.apache.maven.model.Model;
import software.amazon.smithy.cli.shaded.apache.maven.model.Relocation;
import software.amazon.smithy.cli.shaded.apache.maven.model.building.DefaultModelBuilderFactory;
import software.amazon.smithy.cli.shaded.apache.maven.model.building.DefaultModelBuildingRequest;
import software.amazon.smithy.cli.shaded.apache.maven.model.building.FileModelSource;
import software.amazon.smithy.cli.shaded.apache.maven.model.building.ModelBuilder;
import software.amazon.smithy.cli.shaded.apache.maven.model.building.ModelBuildingException;
import software.amazon.smithy.cli.shaded.apache.maven.model.building.ModelProblem;
import software.amazon.smithy.cli.shaded.apache.maven.model.resolution.UnresolvableModelException;
import software.amazon.smithy.cli.shaded.apache.maven.repository.internal.ArtifactDescriptorReaderDelegate;
import software.amazon.smithy.cli.shaded.apache.maven.repository.internal.ArtifactDescriptorUtils;
import software.amazon.smithy.cli.shaded.apache.maven.repository.internal.DefaultModelCache;
import software.amazon.smithy.cli.shaded.apache.maven.repository.internal.DefaultModelResolver;
import software.amazon.smithy.cli.shaded.apache.maven.repository.internal.MavenWorkspaceReader;
import software.amazon.smithy.cli.shaded.apache.maven.repository.internal.RelocatedArtifact;
import software.amazon.smithy.cli.shaded.eclipse.aether.RepositoryEvent;
import software.amazon.smithy.cli.shaded.eclipse.aether.RepositoryException;
import software.amazon.smithy.cli.shaded.eclipse.aether.RepositorySystemSession;
import software.amazon.smithy.cli.shaded.eclipse.aether.RequestTrace;
import software.amazon.smithy.cli.shaded.eclipse.aether.artifact.Artifact;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.ArtifactDescriptorReader;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.ArtifactResolver;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.RemoteRepositoryManager;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.RepositoryEventDispatcher;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.VersionRangeResolver;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.VersionResolver;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.WorkspaceReader;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.WorkspaceRepository;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.ArtifactDescriptorException;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.ArtifactDescriptorPolicyRequest;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.ArtifactDescriptorRequest;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.ArtifactDescriptorResult;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.ArtifactRequest;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.ArtifactResolutionException;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.ArtifactResult;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.VersionRequest;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.VersionResolutionException;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.VersionResult;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.locator.Service;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.locator.ServiceLocator;
import software.amazon.smithy.cli.shaded.eclipse.aether.transfer.ArtifactNotFoundException;
import software.amazon.smithy.cli.shaded.javax.inject.Inject;
import software.amazon.smithy.cli.shaded.javax.inject.Named;
import software.amazon.smithy.cli.shaded.javax.inject.Singleton;

@Named
@Singleton
public class DefaultArtifactDescriptorReader
implements ArtifactDescriptorReader,
Service {
    private RemoteRepositoryManager remoteRepositoryManager;
    private VersionResolver versionResolver;
    private VersionRangeResolver versionRangeResolver;
    private ArtifactResolver artifactResolver;
    private RepositoryEventDispatcher repositoryEventDispatcher;
    private ModelBuilder modelBuilder;

    public DefaultArtifactDescriptorReader() {
    }

    @Inject
    DefaultArtifactDescriptorReader(RemoteRepositoryManager remoteRepositoryManager, VersionResolver versionResolver, VersionRangeResolver versionRangeResolver, ArtifactResolver artifactResolver, ModelBuilder modelBuilder, RepositoryEventDispatcher repositoryEventDispatcher) {
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setVersionResolver(versionResolver);
        this.setVersionRangeResolver(versionRangeResolver);
        this.setArtifactResolver(artifactResolver);
        this.setModelBuilder(modelBuilder);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setVersionResolver(locator.getService(VersionResolver.class));
        this.setVersionRangeResolver(locator.getService(VersionRangeResolver.class));
        this.setArtifactResolver(locator.getService(ArtifactResolver.class));
        this.modelBuilder = locator.getService(ModelBuilder.class);
        if (this.modelBuilder == null) {
            this.setModelBuilder(new DefaultModelBuilderFactory().newInstance());
        }
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
    }

    public DefaultArtifactDescriptorReader setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "remoteRepositoryManager cannot be null");
        return this;
    }

    public DefaultArtifactDescriptorReader setVersionResolver(VersionResolver versionResolver) {
        this.versionResolver = Objects.requireNonNull(versionResolver, "versionResolver cannot be null");
        return this;
    }

    public DefaultArtifactDescriptorReader setVersionRangeResolver(VersionRangeResolver versionRangeResolver) {
        this.versionRangeResolver = Objects.requireNonNull(versionRangeResolver, "versionRangeResolver cannot be null");
        return this;
    }

    public DefaultArtifactDescriptorReader setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = Objects.requireNonNull(artifactResolver, "artifactResolver cannot be null");
        return this;
    }

    public DefaultArtifactDescriptorReader setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        this.repositoryEventDispatcher = Objects.requireNonNull(repositoryEventDispatcher, "repositoryEventDispatcher cannot be null");
        return this;
    }

    public DefaultArtifactDescriptorReader setModelBuilder(ModelBuilder modelBuilder) {
        this.modelBuilder = Objects.requireNonNull(modelBuilder, "modelBuilder cannot be null");
        return this;
    }

    @Override
    public ArtifactDescriptorResult readArtifactDescriptor(RepositorySystemSession session, ArtifactDescriptorRequest request) throws ArtifactDescriptorException {
        ArtifactDescriptorResult result = new ArtifactDescriptorResult(request);
        Model model = this.loadPom(session, request, result);
        if (model != null) {
            Map<String, Object> config = session.getConfigProperties();
            ArtifactDescriptorReaderDelegate delegate = (ArtifactDescriptorReaderDelegate)config.get(ArtifactDescriptorReaderDelegate.class.getName());
            if (delegate == null) {
                delegate = new ArtifactDescriptorReaderDelegate();
            }
            delegate.populateResult(session, result, model);
        }
        return result;
    }

    private Model loadPom(RepositorySystemSession session, ArtifactDescriptorRequest request, ArtifactDescriptorResult result) throws ArtifactDescriptorException {
        Model model;
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        LinkedHashSet<String> visited = new LinkedHashSet<String>();
        Artifact a = request.getArtifact();
        while (true) {
            ArtifactResult resolveResult;
            Artifact pomArtifact = ArtifactDescriptorUtils.toPomArtifact(a);
            try {
                VersionRequest versionRequest = new VersionRequest(a, request.getRepositories(), request.getRequestContext());
                versionRequest.setTrace(trace);
                VersionResult versionResult = this.versionResolver.resolveVersion(session, versionRequest);
                a = a.setVersion(versionResult.getVersion());
                versionRequest = new VersionRequest(pomArtifact, request.getRepositories(), request.getRequestContext());
                versionRequest.setTrace(trace);
                versionResult = this.versionResolver.resolveVersion(session, versionRequest);
                pomArtifact = pomArtifact.setVersion(versionResult.getVersion());
            }
            catch (VersionResolutionException e) {
                result.addException(e);
                throw new ArtifactDescriptorException(result);
            }
            if (!visited.add(a.getGroupId() + ':' + a.getArtifactId() + ':' + a.getBaseVersion())) {
                RepositoryException exception = new RepositoryException("Artifact relocations form a cycle: " + visited);
                this.invalidDescriptor(session, trace, a, exception);
                if ((this.getPolicy(session, a, request) & 2) != 0) {
                    return null;
                }
                result.addException(exception);
                throw new ArtifactDescriptorException(result);
            }
            try {
                ArtifactRequest resolveRequest = new ArtifactRequest(pomArtifact, request.getRepositories(), request.getRequestContext());
                resolveRequest.setTrace(trace);
                resolveResult = this.artifactResolver.resolveArtifact(session, resolveRequest);
                pomArtifact = resolveResult.getArtifact();
                result.setRepository(resolveResult.getRepository());
            }
            catch (ArtifactResolutionException e) {
                if (e.getCause() instanceof ArtifactNotFoundException) {
                    this.missingDescriptor(session, trace, a, (Exception)e.getCause());
                    if ((this.getPolicy(session, a, request) & 1) != 0) {
                        return null;
                    }
                }
                result.addException(e);
                throw new ArtifactDescriptorException(result);
            }
            WorkspaceReader workspace = session.getWorkspaceReader();
            if (workspace instanceof MavenWorkspaceReader && (model = ((MavenWorkspaceReader)workspace).findModel(pomArtifact)) != null) {
                return model;
            }
            try {
                DefaultModelBuildingRequest modelRequest = new DefaultModelBuildingRequest();
                modelRequest.setValidationLevel(0);
                modelRequest.setProcessPlugins(false);
                modelRequest.setTwoPhaseBuilding(false);
                modelRequest.setSystemProperties(this.toProperties(session.getSystemProperties()));
                modelRequest.setUserProperties(this.toProperties(session.getUserProperties()));
                modelRequest.setModelCache(DefaultModelCache.newInstance(session));
                modelRequest.setModelResolver(new DefaultModelResolver(session, trace.newChild(modelRequest), request.getRequestContext(), this.artifactResolver, this.versionRangeResolver, this.remoteRepositoryManager, request.getRepositories()));
                if (resolveResult.getRepository() instanceof WorkspaceRepository) {
                    modelRequest.setPomFile(pomArtifact.getFile());
                } else {
                    modelRequest.setModelSource(new FileModelSource(pomArtifact.getFile()));
                }
                model = this.modelBuilder.build(modelRequest).getEffectiveModel();
            }
            catch (ModelBuildingException e) {
                for (ModelProblem problem : e.getProblems()) {
                    if (!(problem.getException() instanceof UnresolvableModelException)) continue;
                    result.addException(problem.getException());
                    throw new ArtifactDescriptorException(result);
                }
                this.invalidDescriptor(session, trace, a, e);
                if ((this.getPolicy(session, a, request) & 2) != 0) {
                    return null;
                }
                result.addException(e);
                throw new ArtifactDescriptorException(result);
            }
            Relocation relocation = this.getRelocation(model);
            if (relocation == null) break;
            result.addRelocation(a);
            a = new RelocatedArtifact(a, relocation.getGroupId(), relocation.getArtifactId(), relocation.getVersion(), relocation.getMessage());
            result.setArtifact(a);
        }
        return model;
    }

    private Properties toProperties(Map<String, String> map) {
        Properties props = new Properties();
        props.putAll(map);
        return props;
    }

    private Relocation getRelocation(Model model) {
        Relocation relocation = null;
        DistributionManagement distMgmt = model.getDistributionManagement();
        if (distMgmt != null) {
            relocation = distMgmt.getRelocation();
        }
        return relocation;
    }

    private void missingDescriptor(RepositorySystemSession session, RequestTrace trace, Artifact artifact, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_DESCRIPTOR_MISSING);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void invalidDescriptor(RepositorySystemSession session, RequestTrace trace, Artifact artifact, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_DESCRIPTOR_INVALID);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private int getPolicy(RepositorySystemSession session, Artifact a, ArtifactDescriptorRequest request) {
        ArtifactDescriptorPolicy policy = session.getArtifactDescriptorPolicy();
        if (policy == null) {
            return 0;
        }
        return policy.getPolicy(session, new ArtifactDescriptorPolicyRequest(a, request.getRequestContext()));
    }
}

