/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.apache.maven.repository.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.smithy.cli.shaded.apache.maven.repository.internal.RemoteSnapshotMetadata;
import software.amazon.smithy.cli.shaded.eclipse.aether.RepositorySystemSession;
import software.amazon.smithy.cli.shaded.eclipse.aether.artifact.Artifact;
import software.amazon.smithy.cli.shaded.eclipse.aether.deployment.DeployRequest;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.MetadataGenerator;
import software.amazon.smithy.cli.shaded.eclipse.aether.metadata.Metadata;
import software.amazon.smithy.cli.shaded.eclipse.aether.util.ConfigUtils;

class RemoteSnapshotMetadataGenerator
implements MetadataGenerator {
    private final Map<Object, RemoteSnapshotMetadata> snapshots;
    private final boolean legacyFormat;
    private final Date timestamp;

    RemoteSnapshotMetadataGenerator(RepositorySystemSession session, DeployRequest request) {
        this.legacyFormat = ConfigUtils.getBoolean(session, false, "maven.metadata.legacy");
        this.timestamp = (Date)ConfigUtils.getObject(session, (Object)new Date(), "maven.startTime");
        this.snapshots = new LinkedHashMap<Object, RemoteSnapshotMetadata>();
        for (Metadata metadata : request.getMetadata()) {
            if (!(metadata instanceof RemoteSnapshotMetadata)) continue;
            RemoteSnapshotMetadata snapshotMetadata = (RemoteSnapshotMetadata)metadata;
            this.snapshots.put(snapshotMetadata.getKey(), snapshotMetadata);
        }
    }

    @Override
    public Collection<? extends Metadata> prepare(Collection<? extends Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            if (!artifact.isSnapshot()) continue;
            Object key = RemoteSnapshotMetadata.getKey(artifact);
            RemoteSnapshotMetadata snapshotMetadata = this.snapshots.get(key);
            if (snapshotMetadata == null) {
                snapshotMetadata = new RemoteSnapshotMetadata(artifact, this.legacyFormat, this.timestamp);
                this.snapshots.put(key, snapshotMetadata);
            }
            snapshotMetadata.bind(artifact);
        }
        return this.snapshots.values();
    }

    @Override
    public Artifact transformArtifact(Artifact artifact) {
        Object key;
        RemoteSnapshotMetadata snapshotMetadata;
        if (artifact.isSnapshot() && artifact.getVersion().equals(artifact.getBaseVersion()) && (snapshotMetadata = this.snapshots.get(key = RemoteSnapshotMetadata.getKey(artifact))) != null) {
            artifact = artifact.setVersion(snapshotMetadata.getExpandedVersion(artifact));
        }
        return artifact;
    }

    @Override
    public Collection<? extends Metadata> finish(Collection<? extends Artifact> artifacts) {
        return Collections.emptyList();
    }
}

