/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.Supplier;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.CliPrinter;
import software.amazon.smithy.cli.ColorBuffer;
import software.amazon.smithy.cli.ColorFormatter;
import software.amazon.smithy.cli.ColorTheme;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.LoggingArgumentsHandler;
import software.amazon.smithy.cli.StandardOptions;
import software.amazon.smithy.cli.Style;

public final class Cli {
    private ColorFormatter colorFormatter;
    private CliPrinter stdoutPrinter;
    private CliPrinter stderrPrinter;
    private final ClassLoader classLoader;
    private final Command command;
    private final StandardOptions standardOptions = new StandardOptions();

    public Cli(Command command, ClassLoader classLoader) {
        this.command = command;
        this.classLoader = classLoader;
    }

    /*
     * Loose catch block
     */
    public int run(String[] args) {
        if (this.colorFormatter == null) {
            this.colorFormatter(Cli.createDelegatedColorFormatter(this.standardOptions::colorSetting));
        }
        if (this.stdoutPrinter == null) {
            this.stdout(CliPrinter.fromOutputStream(System.out));
        }
        if (this.stderrPrinter == null) {
            this.stderr(CliPrinter.fromOutputStream(System.err));
        }
        LoggingArgumentsHandler arguments = new LoggingArgumentsHandler(this.colorFormatter, this.stderrPrinter, Arguments.of(args));
        arguments.addReceiver(this.standardOptions);
        try {
            try {
                Command.Env env = new Command.Env(this.colorFormatter, this.stdoutPrinter, this.stderrPrinter, this.classLoader);
                int n = this.command.execute(arguments, env);
                return n;
            }
            catch (Exception e) {
                this.stdoutPrinter.flush();
                this.stderrPrinter.flush();
                this.printException(e, this.standardOptions.stackTrace());
                throw CliError.wrap(e);
            }
            finally {
                try {
                    arguments.restoreLogging();
                }
                catch (RuntimeException e) {
                    this.printException(e, this.standardOptions.stackTrace());
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.stdoutPrinter.flush();
            this.stderrPrinter.flush();
        }
    }

    public void colorFormatter(ColorFormatter colorFormatter) {
        this.colorFormatter = colorFormatter;
    }

    public void stdout(CliPrinter stdoutPrinter) {
        this.stdoutPrinter = stdoutPrinter;
    }

    public void stderr(CliPrinter stderrPrinter) {
        this.stderrPrinter = stderrPrinter;
    }

    private void printException(Throwable e, boolean stacktrace) {
        try (ColorBuffer buffer = ColorBuffer.of(this.colorFormatter, this.stderrPrinter);){
            if (!stacktrace) {
                this.colorFormatter.println(this.stderrPrinter, e.getMessage(), ColorTheme.ERROR);
            } else {
                StringWriter writer = new StringWriter();
                e.printStackTrace(new PrintWriter(writer));
                String result = writer.toString();
                int positionOfName = result.indexOf(58);
                buffer.print(result.substring(0, positionOfName), ColorTheme.ERROR);
                buffer.println(result.substring(positionOfName), new Style[0]);
            }
        }
    }

    private static ColorFormatter createDelegatedColorFormatter(final Supplier<ColorFormatter> delegateSupplier) {
        return new ColorFormatter(){

            @Override
            public String style(String text, Style ... styles) {
                return ((ColorFormatter)delegateSupplier.get()).style(text, styles);
            }

            @Override
            public void style(Appendable appendable, String text, Style ... styles) {
                ((ColorFormatter)delegateSupplier.get()).style(appendable, text, styles);
            }

            @Override
            public boolean isColorEnabled() {
                return ((ColorFormatter)delegateSupplier.get()).isColorEnabled();
            }

            @Override
            public void println(Appendable appendable, String text, Style ... styles) {
                ((ColorFormatter)delegateSupplier.get()).println(appendable, text, styles);
            }

            @Override
            public void startStyle(Appendable appendable, Style ... style) {
                ((ColorFormatter)delegateSupplier.get()).startStyle(appendable, style);
            }

            @Override
            public void endStyle(Appendable appendable) {
                ((ColorFormatter)delegateSupplier.get()).endStyle(appendable);
            }
        };
    }
}

