/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.aether.resolution;

import java.util.Collections;
import java.util.List;
import software.amazon.smithy.cli.shaded.eclipse.aether.RepositoryException;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.ArtifactResult;
import software.amazon.smithy.cli.shaded.eclipse.aether.transfer.ArtifactNotFoundException;
import software.amazon.smithy.cli.shaded.eclipse.aether.transfer.RepositoryOfflineException;

public class ArtifactResolutionException
extends RepositoryException {
    private final transient List<ArtifactResult> results;

    public ArtifactResolutionException(List<ArtifactResult> results) {
        super(ArtifactResolutionException.getMessage(results), ArtifactResolutionException.getCause(results));
        this.results = results != null ? results : Collections.emptyList();
    }

    public ArtifactResolutionException(List<ArtifactResult> results, String message) {
        super(message, ArtifactResolutionException.getCause(results));
        this.results = results != null ? results : Collections.emptyList();
    }

    public ArtifactResolutionException(List<ArtifactResult> results, String message, Throwable cause) {
        super(message, cause);
        this.results = results != null ? results : Collections.emptyList();
    }

    public List<ArtifactResult> getResults() {
        return this.results;
    }

    public ArtifactResult getResult() {
        return this.results != null && !this.results.isEmpty() ? this.results.get(0) : null;
    }

    private static String getMessage(List<? extends ArtifactResult> results) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("The following artifacts could not be resolved: ");
        int unresolved = 0;
        String sep = "";
        for (ArtifactResult artifactResult : results) {
            if (artifactResult.isResolved()) continue;
            ++unresolved;
            buffer.append(sep);
            buffer.append(artifactResult.getRequest().getArtifact());
            sep = ", ";
        }
        Throwable cause = ArtifactResolutionException.getCause(results);
        if (cause != null) {
            if (unresolved == 1) {
                buffer.setLength(0);
                buffer.append(cause.getMessage());
            } else {
                buffer.append(": ").append(cause.getMessage());
            }
        }
        return buffer.toString();
    }

    private static Throwable getCause(List<? extends ArtifactResult> results) {
        for (ArtifactResult artifactResult : results) {
            if (artifactResult.isResolved()) continue;
            Throwable notFound = null;
            Throwable offline = null;
            for (Throwable throwable : artifactResult.getExceptions()) {
                if (throwable instanceof ArtifactNotFoundException) {
                    if (notFound == null) {
                        notFound = throwable;
                    }
                    if (offline != null || !(throwable.getCause() instanceof RepositoryOfflineException)) continue;
                    offline = throwable;
                    continue;
                }
                return throwable;
            }
            if (offline != null) {
                return offline;
            }
            if (notFound == null) continue;
            return notFound;
        }
        return null;
    }
}

