/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public interface CliPrinter
extends Appendable,
Flushable {
    @Override
    public CliPrinter append(char var1);

    @Override
    default public CliPrinter append(CharSequence csq) {
        return this.append(csq, 0, csq.length());
    }

    @Override
    public CliPrinter append(CharSequence var1, int var2, int var3);

    default public CliPrinter println(String text) {
        return this.append(text + System.lineSeparator());
    }

    @Override
    default public void flush() {
    }

    public static CliPrinter fromOutputStream(OutputStream stream) {
        Charset charset = StandardCharsets.UTF_8;
        final OutputStreamWriter writer = new OutputStreamWriter(stream, charset);
        return new CliPrinter(){

            @Override
            public CliPrinter append(char c) {
                try {
                    writer.append(c);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                return this;
            }

            @Override
            public CliPrinter append(CharSequence csq) {
                try {
                    writer.append(csq);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                return this;
            }

            @Override
            public CliPrinter append(CharSequence csq, int start, int end) {
                try {
                    writer.append(csq, start, end);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                return this;
            }

            @Override
            public void flush() {
                try {
                    writer.flush();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
    }
}

