/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.dependencies;

import java.nio.file.Path;
import java.util.Objects;
import software.amazon.smithy.cli.dependencies.DependencyResolverException;

public final class ResolvedArtifact {
    private final Path path;
    private final String coordinates;
    private final String groupId;
    private final String artifactId;
    private final String version;

    public ResolvedArtifact(Path path, String groupId, String artifactId, String version) {
        this(path, groupId + ':' + artifactId + ':' + version, groupId, artifactId, version);
    }

    private ResolvedArtifact(Path path, String coordinates, String groupId, String artifactId, String version) {
        this.coordinates = Objects.requireNonNull(coordinates);
        this.path = Objects.requireNonNull(path);
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public static ResolvedArtifact fromCoordinates(Path location, String coordinates) {
        String[] parts = coordinates.split(":");
        if (parts.length != 3) {
            throw new DependencyResolverException("Invalid Maven coordinates: " + coordinates);
        }
        return new ResolvedArtifact(location, coordinates, parts[0], parts[1], parts[2]);
    }

    public Path getPath() {
        return this.path;
    }

    public String getCoordinates() {
        return this.coordinates;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return "{path=" + this.path + ", coordinates='" + this.coordinates + "'}";
    }

    public int hashCode() {
        return Objects.hash(this.coordinates, this.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResolvedArtifact)) {
            return false;
        }
        ResolvedArtifact artifact = (ResolvedArtifact)o;
        return this.path.equals(artifact.path) && this.coordinates.equals(artifact.coordinates);
    }
}

