/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Logger;
import software.amazon.smithy.build.model.MavenConfig;
import software.amazon.smithy.build.model.MavenRepository;
import software.amazon.smithy.build.model.SmithyBuildConfig;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.EnvironmentVariable;
import software.amazon.smithy.cli.SmithyCli;
import software.amazon.smithy.cli.commands.BuildOptions;
import software.amazon.smithy.cli.commands.CommandAction;
import software.amazon.smithy.cli.commands.CommandActionWithConfig;
import software.amazon.smithy.cli.commands.ConfigOptions;
import software.amazon.smithy.cli.commands.IsolatedRunnable;
import software.amazon.smithy.cli.dependencies.DependencyResolver;
import software.amazon.smithy.cli.dependencies.DependencyResolverException;
import software.amazon.smithy.cli.dependencies.FileCacheResolver;
import software.amazon.smithy.cli.dependencies.FilterCliVersionResolver;
import software.amazon.smithy.cli.dependencies.ResolvedArtifact;

class ClasspathAction
implements CommandAction {
    private static final Logger LOGGER = Logger.getLogger(ClasspathAction.class.getName());
    private static final MavenRepository CENTRAL = MavenRepository.builder().url("https://repo.maven.apache.org/maven2").build();
    private final DependencyResolver.Factory dependencyResolverFactory;
    private final CommandActionWithConfig action;

    ClasspathAction(DependencyResolver.Factory dependencyResolverFactory, CommandActionWithConfig action) {
        this.dependencyResolverFactory = dependencyResolverFactory;
        this.action = action;
    }

    @Override
    public int apply(Arguments arguments, Command.Env env) {
        BuildOptions buildOptions = arguments.getReceiver(BuildOptions.class);
        ThreadResult threadResult = new ThreadResult();
        ConfigOptions configOptions = arguments.getReceiver(ConfigOptions.class);
        SmithyBuildConfig config = configOptions.createSmithyBuildConfig();
        this.runTaskWithClasspath(buildOptions, config, env, classLoader -> {
            Command.Env updatedEnv = env.withClassLoader((ClassLoader)classLoader);
            threadResult.returnCode = this.action.apply(config, arguments, updatedEnv);
        });
        return threadResult.returnCode;
    }

    private void runTaskWithClasspath(BuildOptions buildOptions, SmithyBuildConfig smithyBuildConfig, Command.Env env, Consumer<ClassLoader> consumer) {
        Set dependencies = smithyBuildConfig.getMaven().map(MavenConfig::getDependencies).orElse(Collections.emptySet());
        String dependencyMode = EnvironmentVariable.SMITHY_DEPENDENCY_MODE.get();
        boolean useIsolation = false;
        switch (dependencyMode) {
            case "forbid": {
                if (dependencies.isEmpty()) break;
                throw new DependencyResolverException(String.format("%s is set to 'forbid', but the following Maven dependencies are defined in smithy-build.json: %s. Dependencies are forbidden in this configuration.", new Object[]{EnvironmentVariable.SMITHY_DEPENDENCY_MODE, dependencies}));
            }
            case "ignore": {
                if (dependencies.isEmpty()) break;
                LOGGER.warning(() -> String.format("%s is set to 'ignore', and the following Maven dependencies are defined in smithy-build.json: %s. If the build fails, then you may need to manually configure the classpath.", new Object[]{EnvironmentVariable.SMITHY_DEPENDENCY_MODE, dependencies}));
                break;
            }
            case "standard": {
                useIsolation = !dependencies.isEmpty();
                break;
            }
            default: {
                throw new CliError(String.format("Unknown %s setting: '%s'", new Object[]{EnvironmentVariable.SMITHY_DEPENDENCY_MODE, dependencyMode}));
            }
        }
        if (useIsolation) {
            long start = System.nanoTime();
            List<Path> files = this.resolveDependencies(buildOptions, smithyBuildConfig, env, (MavenConfig)smithyBuildConfig.getMaven().get());
            long end = System.nanoTime();
            LOGGER.fine(() -> "Dependency resolution time in ms: " + (end - start) / 1000000L);
            new IsolatedRunnable(files, env.classLoader(), consumer).run();
            LOGGER.fine(() -> "Command time in ms: " + (System.nanoTime() - end) / 1000000L);
        } else {
            consumer.accept(env.classLoader());
        }
    }

    private List<Path> resolveDependencies(BuildOptions buildOptions, SmithyBuildConfig smithyBuildConfig, Command.Env env, MavenConfig maven) {
        DependencyResolver baseResolver = this.dependencyResolverFactory.create(smithyBuildConfig, env);
        long lastModified = smithyBuildConfig.getLastModifiedInMillis();
        FilterCliVersionResolver delegate = new FilterCliVersionResolver(SmithyCli.getVersion(), baseResolver);
        FileCacheResolver resolver = new FileCacheResolver(this.getCacheFile(buildOptions, smithyBuildConfig), lastModified, delegate);
        ClasspathAction.addConfiguredMavenRepos(smithyBuildConfig, resolver);
        maven.getDependencies().forEach(resolver::addDependency);
        List<ResolvedArtifact> artifacts = resolver.resolve();
        LOGGER.fine(() -> "Classpath resolved with Maven: " + artifacts);
        ArrayList<Path> result = new ArrayList<Path>(artifacts.size());
        for (ResolvedArtifact artifact : artifacts) {
            result.add(artifact.getPath());
        }
        return result;
    }

    private static void addConfiguredMavenRepos(SmithyBuildConfig config, DependencyResolver resolver) {
        Set<MavenRepository> configuredRepos;
        String envRepos = EnvironmentVariable.SMITHY_MAVEN_REPOS.get();
        if (envRepos != null) {
            for (String repo : envRepos.split("\\|")) {
                resolver.addRepository(MavenRepository.builder().url(repo.trim()).build());
            }
        }
        if (!(configuredRepos = config.getMaven().map(MavenConfig::getRepositories).orElse(Collections.emptySet())).isEmpty()) {
            configuredRepos.forEach(resolver::addRepository);
        } else if (envRepos == null) {
            LOGGER.finest(() -> String.format("maven.repositories is not defined in smithy-build.json and the %s environment variable is not set. Defaulting to Maven Central.", new Object[]{EnvironmentVariable.SMITHY_MAVEN_REPOS}));
            resolver.addRepository(CENTRAL);
        }
    }

    private File getCacheFile(BuildOptions buildOptions, SmithyBuildConfig config) {
        return buildOptions.resolveOutput(config).resolve("classpath.json").toFile();
    }

    static final class ThreadResult {
        int returnCode;

        ThreadResult() {
        }
    }
}

