/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.apache.maven.model.profile.activation;

import software.amazon.smithy.cli.shaded.apache.maven.model.Activation;
import software.amazon.smithy.cli.shaded.apache.maven.model.ActivationProperty;
import software.amazon.smithy.cli.shaded.apache.maven.model.Profile;
import software.amazon.smithy.cli.shaded.apache.maven.model.building.ModelProblem;
import software.amazon.smithy.cli.shaded.apache.maven.model.building.ModelProblemCollector;
import software.amazon.smithy.cli.shaded.apache.maven.model.building.ModelProblemCollectorRequest;
import software.amazon.smithy.cli.shaded.apache.maven.model.profile.ProfileActivationContext;
import software.amazon.smithy.cli.shaded.apache.maven.model.profile.activation.ProfileActivator;
import software.amazon.smithy.cli.shaded.codehaus.plexus.util.StringUtils;
import software.amazon.smithy.cli.shaded.javax.inject.Named;
import software.amazon.smithy.cli.shaded.javax.inject.Singleton;

@Named(value="property")
@Singleton
public class PropertyProfileActivator
implements ProfileActivator {
    @Override
    public boolean isActive(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        String propValue;
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationProperty property = activation.getProperty();
        if (property == null) {
            return false;
        }
        String name = property.getName();
        boolean reverseName = false;
        if (name != null && name.startsWith("!")) {
            reverseName = true;
            name = name.substring(1);
        }
        if (name == null || name.length() <= 0) {
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("The property name is required to activate the profile " + profile.getId()).setLocation(property.getLocation("")));
            return false;
        }
        String sysValue = context.getUserProperties().get(name);
        if (sysValue == null) {
            sysValue = context.getSystemProperties().get(name);
        }
        if (StringUtils.isNotEmpty(propValue = property.getValue())) {
            boolean reverseValue = false;
            if (propValue.startsWith("!")) {
                reverseValue = true;
                propValue = propValue.substring(1);
            }
            boolean result = propValue.equals(sysValue);
            return reverseValue ? !result : result;
        }
        boolean result = StringUtils.isNotEmpty(sysValue);
        return reverseName ? !result : result;
    }

    @Override
    public boolean presentInConfig(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationProperty property = activation.getProperty();
        return property != null;
    }
}

