/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.aether.transport.http;

import java.util.Collections;
import java.util.Map;
import software.amazon.smithy.cli.shaded.apache.http.Header;
import software.amazon.smithy.cli.shaded.apache.http.HttpResponse;
import software.amazon.smithy.cli.shaded.eclipse.aether.transport.http.ChecksumExtractor;
import software.amazon.smithy.cli.shaded.javax.inject.Named;
import software.amazon.smithy.cli.shaded.javax.inject.Singleton;

@Singleton
@Named(value="nexus2")
public class Nexus2ChecksumExtractor
extends ChecksumExtractor {
    public static final String NAME = "nexus2";

    @Override
    public Map<String, String> extractChecksums(HttpResponse response) {
        String etag;
        Header header = response.getFirstHeader("ETag");
        String string = etag = header != null ? header.getValue() : null;
        if (etag != null) {
            int start = etag.indexOf("SHA1{");
            int end = etag.indexOf("}", start + 5);
            if (start >= 0 && end > start) {
                return Collections.singletonMap("SHA-1", etag.substring(start + 5, end));
            }
        }
        return null;
    }
}

