/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.StringJoiner;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.CliPrinter;
import software.amazon.smithy.cli.ColorBuffer;
import software.amazon.smithy.cli.ColorFormatter;
import software.amazon.smithy.cli.ColorTheme;
import software.amazon.smithy.cli.StandardOptions;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidatedResult;

final class Validator {
    private Validator() {
    }

    static void validate(boolean quiet, ColorFormatter colors, CliPrinter printer, ValidatedResult<Model> result) {
        int notes = result.getValidationEvents(Severity.NOTE).size();
        int warnings = result.getValidationEvents(Severity.WARNING).size();
        int errors = result.getValidationEvents(Severity.ERROR).size();
        int dangers = result.getValidationEvents(Severity.DANGER).size();
        int shapeCount = result.getResult().isPresent() ? ((Model)result.getResult().get()).toSet().size() : 0;
        boolean isFailed = errors > 0 || dangers > 0;
        boolean hasEvents = warnings > 0 || notes > 0 || isFailed;
        try (ColorBuffer output = ColorBuffer.of(colors, new StringBuilder());){
            if (isFailed) {
                output.append(colors.style("FAILURE: ", ColorTheme.ERROR));
            } else {
                output.append(colors.style("SUCCESS: ", ColorTheme.SUCCESS));
            }
            output.append("Validated " + shapeCount).append(" shapes");
            if (hasEvents) {
                output.append(' ').append('(');
                StringJoiner joiner = new StringJoiner(", ");
                if (errors > 0) {
                    Validator.appendSummaryCount(joiner, "ERROR", errors);
                }
                if (dangers > 0) {
                    Validator.appendSummaryCount(joiner, "DANGER", dangers);
                }
                if (warnings > 0) {
                    Validator.appendSummaryCount(joiner, "WARNING", warnings);
                }
                if (notes > 0) {
                    Validator.appendSummaryCount(joiner, "NOTE", notes);
                }
                output.append(joiner.toString());
                output.append(')');
            }
            output.append(System.lineSeparator());
            if (!result.getResult().isPresent() || errors + dangers > 0) {
                throw new CliError(output.toString());
            }
            if (!quiet) {
                printer.println(output.toString());
            }
        }
    }

    private static void appendSummaryCount(StringJoiner joiner, String label, int count) {
        joiner.add(label + ": " + count);
    }

    static enum Mode {
        QUIET,
        QUIET_CORE_ONLY,
        ENABLE;


        static Mode from(StandardOptions standardOptions) {
            return standardOptions.quiet() ? QUIET : ENABLE;
        }
    }
}

