/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.io.IOException;
import java.io.UncheckedIOException;
import software.amazon.smithy.cli.Style;

public interface ColorFormatter {
    default public String style(String text, Style ... styles) {
        if (!this.isColorEnabled()) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        this.style(builder, text, styles);
        return builder.toString();
    }

    default public void style(Appendable appendable, String text, Style ... styles) {
        try {
            this.startStyle(appendable, styles);
            appendable.append(text);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (styles.length > 0) {
                this.endStyle(appendable);
            }
        }
    }

    default public void println(Appendable appendable, String text, Style ... styles) {
        this.style(appendable, text + System.lineSeparator(), styles);
    }

    public boolean isColorEnabled();

    public void startStyle(Appendable var1, Style ... var2);

    public void endStyle(Appendable var1);
}

