/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.io.BufferedWriter;
import java.io.Flushable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

@FunctionalInterface
public interface CliPrinter
extends Flushable {
    public void print(String var1);

    default public void println(String text) {
        this.print(text + System.lineSeparator());
    }

    @Override
    default public void flush() {
    }

    public static CliPrinter fromPrintWriter(final PrintWriter printWriter) {
        return new CliPrinter(){

            @Override
            public void println(String text) {
                printWriter.println(text);
            }

            @Override
            public void print(String text) {
                printWriter.print(text);
            }

            @Override
            public void flush() {
                printWriter.flush();
            }
        };
    }

    public static CliPrinter fromOutputStream(OutputStream stream) {
        Charset charset = StandardCharsets.UTF_8;
        PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(stream, charset)), false);
        return CliPrinter.fromPrintWriter(writer);
    }
}

