/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.aether;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import software.amazon.smithy.cli.shaded.eclipse.aether.SessionData;

public final class DefaultSessionData
implements SessionData {
    private final ConcurrentMap<Object, Object> data = new ConcurrentHashMap<Object, Object>();

    @Override
    public void set(Object key, Object value) {
        Objects.requireNonNull(key, "key cannot be null");
        if (value != null) {
            this.data.put(key, value);
        } else {
            this.data.remove(key);
        }
    }

    @Override
    public boolean set(Object key, Object oldValue, Object newValue) {
        Objects.requireNonNull(key, "key cannot be null");
        if (newValue != null) {
            if (oldValue == null) {
                return this.data.putIfAbsent(key, newValue) == null;
            }
            return this.data.replace(key, oldValue, newValue);
        }
        if (oldValue == null) {
            return !this.data.containsKey(key);
        }
        return this.data.remove(key, oldValue);
    }

    @Override
    public Object get(Object key) {
        Objects.requireNonNull(key, "key cannot be null");
        return this.data.get(key);
    }

    @Override
    public Object computeIfAbsent(Object key, Supplier<Object> supplier) {
        return this.data.computeIfAbsent(key, (? super K k) -> supplier.get());
    }
}

