/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.sisu.space;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.AnnotationVisitor;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.ClassSpace;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.ClassVisitor;
import software.amazon.smithy.cli.shaded.eclipse.sisu.space.SpaceScanner;

final class QualifierCache
implements ClassVisitor {
    private static final String QUALIFIER_DESC = "Lsoftware/amazon/smithy/cli/shaded/javax/inject/Qualifier;";
    private static final String NAMED_DESC = "Lsoftware/amazon/smithy/cli/shaded/javax/inject/Named;";
    private static final Map<String, Boolean> cachedResults = new ConcurrentHashMap<String, Boolean>(32, 0.75f, 1);
    private boolean isQualified;

    QualifierCache() {
    }

    @Override
    public void enterClass(int modifiers, String name, String _extends, String[] _implements) {
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc) {
        this.isQualified |= QUALIFIER_DESC.equals(desc);
        return null;
    }

    @Override
    public void leaveClass() {
    }

    boolean qualify(ClassSpace space, String desc) {
        if (NAMED_DESC.equals(desc)) {
            return true;
        }
        Boolean result = cachedResults.get(desc);
        if (result == null) {
            this.isQualified = false;
            String name = desc.substring(1, desc.length() - 1);
            SpaceScanner.accept(this, space.getResource(String.valueOf(name) + ".class"));
            cachedResults.put(desc, this.isQualified);
            return this.isQualified;
        }
        return result;
    }
}

