/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.List;
import java.util.logging.Logger;
import software.amazon.smithy.cli.ArgumentReceiver;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.CliPrinter;
import software.amazon.smithy.cli.ColorFormatter;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.HelpPrinter;
import software.amazon.smithy.cli.StandardOptions;
import software.amazon.smithy.utils.StringUtils;

abstract class SimpleCommand
implements Command {
    private static final Logger LOGGER = Logger.getLogger(SimpleCommand.class.getName());
    private final String parentCommandName;

    SimpleCommand(String parentCommandName) {
        this.parentCommandName = parentCommandName;
    }

    @Override
    public final int execute(Arguments arguments, Command.Env env) {
        List<ArgumentReceiver> receivers = this.createArgumentReceivers();
        for (ArgumentReceiver receiver : receivers) {
            arguments.addReceiver(receiver);
        }
        List<String> positionalArguments = arguments.finishParsing();
        StandardOptions options = arguments.getReceiver(StandardOptions.class);
        if (arguments.getReceiver(StandardOptions.class).version()) {
            throw new CliError("Unexpected CLI argument: --version");
        }
        if (options.help()) {
            this.printHelp(arguments, env.colors(), env.stdout());
            return 0;
        }
        LOGGER.fine(() -> "Invoking Command with positional arguments: " + positionalArguments);
        return this.run(arguments, env, positionalArguments);
    }

    @Override
    public void printHelp(Arguments arguments, ColorFormatter colors, CliPrinter printer) {
        String name = StringUtils.isEmpty((CharSequence)this.parentCommandName) ? this.getName() : this.parentCommandName + " " + this.getName();
        HelpPrinter.fromArguments(name, arguments).summary(this.getSummary()).documentation(this.getDocumentation(colors)).print(colors, printer);
    }

    protected abstract List<ArgumentReceiver> createArgumentReceivers();

    protected abstract int run(Arguments var1, Command.Env var2, List<String> var3);
}

