/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.build.model.SmithyBuildConfig;
import software.amazon.smithy.cli.ArgumentReceiver;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.ColorFormatter;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.HelpPrinter;
import software.amazon.smithy.cli.StandardOptions;
import software.amazon.smithy.cli.Style;
import software.amazon.smithy.cli.commands.ClasspathCommand;
import software.amazon.smithy.cli.commands.CommandUtils;
import software.amazon.smithy.cli.dependencies.DependencyResolver;
import software.amazon.smithy.diff.ModelDiff;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidatedResult;
import software.amazon.smithy.model.validation.ValidationEvent;

final class DiffCommand
extends ClasspathCommand {
    private static final Logger LOGGER = Logger.getLogger(DiffCommand.class.getName());

    DiffCommand(String parentCommandName, DependencyResolver.Factory dependencyResolverFactory) {
        super(parentCommandName, dependencyResolverFactory);
    }

    @Override
    public String getName() {
        return "diff";
    }

    @Override
    public String getSummary() {
        return "Compares two Smithy models and reports any significant changes.";
    }

    @Override
    protected void addAdditionalArgumentReceivers(List<ArgumentReceiver> receivers) {
        receivers.add(new Options());
    }

    @Override
    int runWithClassLoader(SmithyBuildConfig config, Arguments arguments, Command.Env env, List<String> positional) {
        StandardOptions standardOptions = arguments.getReceiver(StandardOptions.class);
        Options options = arguments.getReceiver(Options.class);
        ClassLoader classLoader = env.classLoader();
        List oldModels = options.oldModels;
        List newModels = options.newModels;
        LOGGER.fine(() -> String.format("Setting old models to: %s; new models to: %s", oldModels, newModels));
        ModelAssembler assembler = CommandUtils.createModelAssembler(classLoader);
        Model oldModel = this.loadModel("old", assembler, oldModels);
        assembler.reset();
        Model newModel = this.loadModel("new", assembler, newModels);
        List events = ModelDiff.compare((ClassLoader)classLoader, (Model)oldModel, (Model)newModel);
        boolean hasError = events.stream().anyMatch(event -> event.getSeverity() == Severity.ERROR);
        boolean hasDanger = events.stream().anyMatch(event -> event.getSeverity() == Severity.DANGER);
        boolean hasWarning = events.stream().anyMatch(event -> event.getSeverity() == Severity.DANGER);
        String result = events.stream().map(ValidationEvent::toString).collect(Collectors.joining("\n"));
        if (hasError) {
            throw new CliError(String.format("Model diff detected errors: %n%s", result));
        }
        if (!result.isEmpty()) {
            env.stdout().println(result);
        }
        if (!standardOptions.quiet()) {
            try (ColorFormatter.PrinterBuffer buffer = env.colors().printerBuffer(env.stderr());){
                if (hasDanger) {
                    buffer.println("Smithy diff detected danger", Style.BRIGHT_RED, Style.BOLD);
                } else if (hasWarning) {
                    buffer.println("Smithy diff detected warnings", Style.BRIGHT_YELLOW, Style.BOLD);
                } else {
                    buffer.println("Smithy diff complete", Style.BRIGHT_GREEN, Style.BOLD);
                }
            }
        }
        return 0;
    }

    private Model loadModel(String descriptor, ModelAssembler assembler, List<String> models) {
        models.forEach(arg_0 -> ((ModelAssembler)assembler).addImport(arg_0));
        ValidatedResult result = assembler.assemble();
        if (result.isBroken()) {
            throw new CliError("Error loading " + descriptor + " models: \n" + result.getValidationEvents().stream().map(ValidationEvent::toString).collect(Collectors.joining("\n")));
        }
        return (Model)result.unwrap();
    }

    private static final class Options
    implements ArgumentReceiver {
        private final List<String> oldModels = new ArrayList<String>();
        private final List<String> newModels = new ArrayList<String>();

        private Options() {
        }

        @Override
        public boolean testOption(String name) {
            return false;
        }

        @Override
        public Consumer<String> testParameter(String name) {
            if (name.equals("--old")) {
                return this.oldModels::add;
            }
            if (name.equals("--new")) {
                return this.newModels::add;
            }
            return null;
        }

        @Override
        public void registerHelp(HelpPrinter printer) {
            printer.param("--old", null, "OLD_MODELS...", "Path to an old Smithy model or directory that contains models. This option can be repeated to merge multiple files or directories (e.g., --old /path/old/one --old /path/old/two).");
            printer.param("--new", null, "NEW_MODELS...", "Path to the new Smithy model or directory that contains models. This option can be repeated to merge multiple files or directories.(e.g., --new /path/new/one --new /path/new/two)");
        }
    }
}

