/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Logger;
import software.amazon.smithy.build.SmithyBuild;
import software.amazon.smithy.build.model.SmithyBuildConfig;
import software.amazon.smithy.cli.ArgumentReceiver;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.commands.ConfigOptions;
import software.amazon.smithy.cli.commands.SimpleCommand;
import software.amazon.smithy.utils.IoUtils;
import software.amazon.smithy.utils.ListUtils;

final class CleanCommand
extends SimpleCommand {
    private static final Logger LOGGER = Logger.getLogger(CleanCommand.class.getName());

    CleanCommand(String parentCommandName) {
        super(parentCommandName);
    }

    @Override
    protected List<ArgumentReceiver> createArgumentReceivers() {
        return ListUtils.of((Object)new ConfigOptions());
    }

    @Override
    public String getName() {
        return "clean";
    }

    @Override
    public String getSummary() {
        return "Removes Smithy build artifacts.";
    }

    @Override
    protected int run(Arguments arguments, Command.Env env, List<String> positional) {
        ConfigOptions options = arguments.getReceiver(ConfigOptions.class);
        SmithyBuildConfig config = options.createSmithyBuildConfig();
        Path dir = config.getOutputDirectory().map(x$0 -> Paths.get(x$0, new String[0])).orElseGet(SmithyBuild::getDefaultOutputDirectory);
        LOGGER.fine(() -> "Deleting directory: " + dir);
        if (!IoUtils.rmdir((Path)dir)) {
            LOGGER.fine(() -> "Directory does not exist: " + dir);
        }
        LOGGER.fine(() -> "Deleted directory " + dir);
        return 0;
    }
}

