/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliPrinter;
import software.amazon.smithy.cli.ColorFormatter;

public interface Command {
    public String getName();

    default public boolean isHidden() {
        return false;
    }

    public String getSummary();

    default public String getDocumentation(ColorFormatter colors) {
        return "";
    }

    public void printHelp(Arguments var1, ColorFormatter var2, CliPrinter var3);

    public int execute(Arguments var1, Env var2);

    public static final class Env {
        private final CliPrinter stdout;
        private final CliPrinter stderr;
        private final ColorFormatter colors;
        private final ClassLoader classLoader;

        public Env(ColorFormatter colors, CliPrinter stdout, CliPrinter stderr, ClassLoader classLoader) {
            this.colors = colors;
            this.stdout = stdout;
            this.stderr = stderr;
            this.classLoader = classLoader;
        }

        public ColorFormatter colors() {
            return this.colors;
        }

        public CliPrinter stdout() {
            return this.stdout;
        }

        public CliPrinter stderr() {
            return this.stderr;
        }

        public ClassLoader classLoader() {
            return this.classLoader == null ? this.getClass().getClassLoader() : this.classLoader;
        }

        public Env withClassLoader(ClassLoader classLoader) {
            return classLoader == this.classLoader ? this : new Env(this.colors, this.stdout, this.stderr, classLoader);
        }
    }
}

